/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.quad;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public final class QuadModifier {
    private static final QuadModifier FAILED = new QuadModifier(null, true, -1, false, true);
    private static final QuadModifier FAILED_FULL = new QuadModifier(null, false, -1, false, true);
    private final Data data;
    private final boolean limited;
    private int tintIndex = -1;
    private boolean noShade;
    private boolean failed;

    public static QuadModifier geometry(BakedQuad quad) {
        float[][] pos = new float[4][3];
        float[][] uv = new float[4][2];
        float[][] normal = new float[4][3];
        int[] vertexData = quad.m_111303_();
        for (int i = 0; i < 4; ++i) {
            ModelUtils.unpackPosition(vertexData, pos[i], i);
            ModelUtils.unpackUV(vertexData, uv[i], i);
            ModelUtils.unpackNormals(vertexData, normal[i], i);
        }
        return new QuadModifier(new Data(quad, pos, uv, normal), true, -1, false, false);
    }

    public static QuadModifier full(BakedQuad quad) {
        float[][] pos = new float[4][3];
        float[][] uv = new float[4][2];
        float[][] normal = new float[4][3];
        int[][] color = new int[4][4];
        int[][] light = new int[4][2];
        int[] vertexData = quad.m_111303_();
        for (int i = 0; i < 4; ++i) {
            ModelUtils.unpackPosition(vertexData, pos[i], i);
            ModelUtils.unpackUV(vertexData, uv[i], i);
            ModelUtils.unpackNormals(vertexData, normal[i], i);
            ModelUtils.unpackColor(vertexData, color[i], i);
            ModelUtils.unpackLight(vertexData, light[i], i);
        }
        return new QuadModifier(new Data(quad, pos, uv, normal, color, light), false, -1, false, false);
    }

    private QuadModifier(Data data, boolean limited, int tintIndex, boolean noShade, boolean failed) {
        this.data = data;
        this.limited = limited;
        this.tintIndex = tintIndex;
        this.noShade = noShade;
        this.failed = failed;
    }

    public QuadModifier applyIf(Modifier modifier, boolean apply) {
        return apply ? this.apply(modifier) : this;
    }

    public QuadModifier apply(Modifier modifier) {
        if (!this.failed) {
            this.failed = !modifier.accept(this.data);
        }
        return this;
    }

    public QuadModifier tintIndex(int tintIndex) {
        Preconditions.checkState((this.tintIndex == -1 ? 1 : 0) != 0, (Object)"TintIndex has already been set");
        this.tintIndex = tintIndex;
        return this;
    }

    public QuadModifier noShade() {
        this.noShade = true;
        return this;
    }

    public void export(List<BakedQuad> quadList) {
        this.export(quadList::add);
    }

    public void export(Consumer<BakedQuad> quadConsumer) {
        if (this.failed) {
            return;
        }
        int[] vertexData = this.data.quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        this.packVertexData(vertexData);
        BakedQuad newQuad = new BakedQuad(vertexData, this.tintIndex == -1 ? this.data.quad.m_111305_() : this.tintIndex, this.data.quad.m_111306_(), this.data.quad.m_173410_(), !this.noShade && this.data.quad.m_111307_(), this.data.quad.hasAmbientOcclusion());
        ModelUtils.fillNormal(newQuad);
        quadConsumer.accept(newQuad);
    }

    public void modifyInPlace() {
        Preconditions.checkState((this.tintIndex == -1 ? 1 : 0) != 0, (Object)"In-place modification can't change tintIndex but a tintIndex has been set");
        Preconditions.checkState((!this.noShade ? 1 : 0) != 0, (Object)"In-place modification can't change shading but noShade has been set");
        if (this.failed) {
            return;
        }
        this.packVertexData(this.data.quad.m_111303_());
        ModelUtils.fillNormal(this.data.quad);
    }

    private void packVertexData(int[] vertexData) {
        for (int i = 0; i < 4; ++i) {
            ModelUtils.packPosition(this.data.pos[i], vertexData, i);
            ModelUtils.packUV(this.data.uv[i], vertexData, i);
            ModelUtils.packNormals(this.data.normal[i], vertexData, i);
            if (this.data.color != null) {
                ModelUtils.packColor(this.data.color[i], vertexData, i);
            }
            if (this.data.light == null) continue;
            ModelUtils.packLight(this.data.light[i], vertexData, i);
        }
    }

    public QuadModifier derive() {
        if (this.failed) {
            return this.limited ? FAILED : FAILED_FULL;
        }
        return new QuadModifier(new Data(this.data), this.limited, this.tintIndex, this.noShade, false);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public record Data(BakedQuad quad, float[][] pos, float[][] uv, float[][] normal, int[][] color, int[][] light, boolean uvRotated, boolean uvMirrored) {
        public Data(BakedQuad quad, float[][] pos, float[][] uv, float[][] normal, int[][] color, int[][] light) {
            this(quad, pos, uv, normal, color, light, ModelUtils.isQuadRotated(uv), ModelUtils.isQuadMirrored(uv));
        }

        public Data(BakedQuad quad, float[][] pos, float[][] uv, float[][] normal) {
            this(quad, pos, uv, normal, null, null);
        }

        public Data(Data data) {
            this(data.quad, Data.deepCopy(data.pos), Data.deepCopy(data.uv), Data.deepCopy(data.normal), data.color != null ? Data.deepCopy(data.color) : null, data.light != null ? Data.deepCopy(data.light) : null);
        }

        private static float[][] deepCopy(float[][] arr) {
            float[][] newArr = new float[arr.length][];
            for (int i = 0; i < arr.length; ++i) {
                newArr[i] = Arrays.copyOf(arr[i], arr[i].length);
            }
            return newArr;
        }

        private static int[][] deepCopy(int[][] arr) {
            int[][] newArr = new int[arr.length][];
            for (int i = 0; i < arr.length; ++i) {
                newArr[i] = Arrays.copyOf(arr[i], arr[i].length);
            }
            return newArr;
        }
    }

    @FunctionalInterface
    public static interface Modifier {
        public boolean accept(Data var1);
    }
}

