/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.exchangers.util.IExchanger;
import jackyy.exchangers.util.ILoadable;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.helper.KeyHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemExchangerBase
extends Item
implements IExchanger,
ILoadable {
    public ItemExchangerBase(Item.Properties props) {
        super(props.m_41491_(Reference.TAB));
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (!world.m_5776_() && player != null) {
            if (player.m_6144_()) {
                ExchangerHandler.selectBlock(player.m_21205_(), player, world, pos);
            } else {
                ExchangerHandler.placeBlock(player.m_21205_(), player, world, pos, side, context);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        ExchangerHandler.setDefaultTagCompound(stack);
        CompoundTag compound = NBTHelper.getTag((ItemStack)stack);
        BlockState state = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("blockstate"));
        Block block = state.m_60734_();
        int mode = compound.m_128451_("mode");
        if (!KeyHelper.isShiftKeyDown()) {
            tooltip.add((Component)StringHelper.getShiftText((String)"exchangers"));
        }
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block", (Object[])new Object[]{block == Blocks.f_50016_ ? StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block.none", (Object[])new Object[0]).m_130940_(ChatFormatting.RED) : ExchangerHandler.getBlockName(block).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.current_range", (Object[])new Object[]{ChatFormatting.GREEN + ExchangerHandler.rangeList[compound.m_128451_("range")]}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.max_range", (Object[])new Object[]{Component.m_237113_((String)ExchangerHandler.rangeList[this.getMaxRange()]).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.max_harvest_level", (Object[])new Object[]{StringHelper.formatHarvestLevel((String)this.getHarvestLevel()).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
            switch (mode) {
                case 0: {
                    tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModePlane.getDisplayName().m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
                    break;
                }
                case 1: {
                    tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
                    break;
                }
                case 2: {
                    tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
                }
            }
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.silk_touch", (Object[])new Object[]{Reference.getStateString((Boolean)ModConfigs.CONFIG.doExchangersSilkTouch.get())}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items", (Object[])new Object[]{Reference.getStateString(compound.m_128471_("forceDropItems"))}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement", (Object[])new Object[]{Reference.getStateString(compound.m_128471_("directionalPlacement"))}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement", (Object[])new Object[]{Reference.getStateString(compound.m_128471_("fuzzyPlacement"))}).m_130940_(ChatFormatting.WHITE));
        }
        if (!KeyHelper.isCtrlKeyDown()) {
            tooltip.add((Component)StringHelper.getCtrlText((String)"exchangers"));
        }
        if (KeyHelper.isCtrlKeyDown()) {
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.extra1", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.extra2", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.extra3", (Object[])new Object[]{Component.m_237115_((String)((KeyMapping)Keys.OPEN_GUI_KEY.get()).getKey().toString()).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE));
        }
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((Component)StringHelper.getTierText((String)"exchangers", (int)this.getTier()));
            if (!this.isPowered()) {
                tooltip.add((Component)StringHelper.formatNumber((long)(stack.m_41776_() - stack.m_41773_())).m_130946_(" / ").m_7220_((Component)StringHelper.formatNumber((long)stack.m_41776_())).m_130946_(" ").m_7220_((Component)StringHelper.localize((String)"exchangers", (String)"tooltip.durability", (Object[])new Object[0])));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group) && this.checkLoaded()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Override
    public boolean checkLoaded() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44985_ || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }
}

