/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.item.ItemWerewolfFleshConfig;

public class ItemWerewolfFlesh
extends Item {
    private static final int POISON_DURATION = 10;
    private static final int POWER_DURATION = 60;
    private static final int POWER_DURATION_BONUS = 240;
    private final boolean humanoid;
    private boolean power = false;
    public static final int MINECRAFT_DAY = 24000;

    public ItemWerewolfFlesh(Item.Properties properties, boolean humanoid) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()));
        this.humanoid = humanoid;
        if (this.humanoid) {
            MinecraftForge.EVENT_BUS.addListener(this::dropHumanoidFleshEvent);
        }
    }

    public static boolean isDay(Level world) {
        return world.m_46468_() % 24000L < 12000L;
    }

    private boolean isPower(Level world) {
        return world == null ? this.power : (this.power = !ItemWerewolfFlesh.isDay(world));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rarity m_41460_(ItemStack itemStack) {
        return this.isHumanFlesh(itemStack) ? Rarity.RARE : Rarity.EPIC;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.isPower(null);
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity player, int par4, boolean par5) {
        this.isPower(world);
    }

    private int getPowerDuration(ItemStack itemStack) {
        if (this.isHumanFlesh(itemStack)) {
            return 60;
        }
        return 240;
    }

    private boolean isHumanFlesh(ItemStack itemStack) {
        return this.humanoid;
    }

    private boolean isOwnCanibal(ItemStack itemStack, Player player) {
        if (itemStack.m_41782_()) {
            GameProfile profile = NbtUtils.m_129228_((CompoundTag)itemStack.m_41783_());
            return player.m_36316_().equals((Object)profile);
        }
        return false;
    }

    public ItemStack m_5922_(ItemStack itemStack, @Nullable Level world, LivingEntity entity) {
        if (world != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, itemStack);
            }
            if (this.isOwnCanibal(itemStack, player)) {
                if (!world.m_5776_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, this.getPowerDuration(itemStack) * 20, 1));
                }
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12621_, SoundSource.HOSTILE, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            } else if (this.isPower(world)) {
                int foodLevel = this.m_41473_().m_38744_();
                float saturationLevel = this.m_41473_().m_38745_();
                player.m_36324_().m_38707_(foodLevel, saturationLevel);
                player.m_36324_().m_38703_(20.0f);
                if (!world.m_5776_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, this.getPowerDuration(itemStack) * 20, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, this.getPowerDuration(itemStack) * 20, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, this.getPowerDuration(itemStack) * 20, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, this.getPowerDuration(itemStack) * 20, 2));
                }
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12620_, SoundSource.HOSTILE, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            } else {
                if (!world.m_5776_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
                }
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12621_, SoundSource.HOSTILE, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            entity.m_5584_(world, itemStack);
        }
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        if (this.isHumanFlesh(itemStack)) {
            GameProfile profile;
            Object player = ChatFormatting.ITALIC + "None";
            if (itemStack.m_41782_() && (profile = NbtUtils.m_129228_((CompoundTag)itemStack.m_41783_())) != null && profile.isComplete()) {
                player = profile.getName();
            }
            list.add((Component)Component.m_237113_((String)"Player: ").m_130940_(ChatFormatting.WHITE).m_130946_((String)player));
        }
    }

    public void dropHumanoidFleshEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer && !event.getEntity().f_19853_.m_5776_() && event.getEntity().f_19853_.f_46441_.m_188503_(ItemWerewolfFleshConfig.humanoidFleshDropChance) == 0) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CompoundTag tag = itemStack.m_41784_();
            NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)player.m_36316_());
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            ItemEntity entity = new ItemEntity(player.f_19853_, x, y, z, itemStack);
            player.f_19853_.m_7967_((Entity)entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int m_92671_(ItemStack itemStack, int renderPass) {
            if (((ItemWerewolfFlesh)itemStack.m_41720_()).isHumanFlesh(itemStack)) {
                return Helpers.RGBToInt((int)255, (int)200, (int)180);
            }
            return -1;
        }
    }
}

