/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;

public class RegistryExportableBroomModifier
implements IRegistryExportable {
    public JsonObject export() {
        JsonObject root = new JsonObject();
        for (BroomModifier modifier : BroomModifiers.REGISTRY.getModifiers()) {
            JsonObject object = new JsonObject();
            JsonArray items = new JsonArray();
            for (Map.Entry<ItemStack, Float> entry : BroomModifiers.REGISTRY.getItemsFromModifier(modifier).entrySet()) {
                JsonObject item = new JsonObject();
                item.add("item", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)entry.getKey()));
                item.addProperty("modifier", (Number)entry.getValue());
                items.add((JsonElement)item);
            }
            object.add("items", (JsonElement)items);
            object.addProperty("name", modifier.getTranslationKey());
            root.add("evilcraft:" + modifier.getName(), (JsonElement)object);
        }
        return root;
    }

    public String getName() {
        return "broom_modifier";
    }
}

