/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class TerraformDegradation
extends StochasticDegradationEffect {
    private static Map<Block, Map<BlockState, Integer>> TERRAFORMATIONS = Maps.newHashMap();
    private static final double CHANCE = 0.1;
    private static Random random = new Random();

    private static void generateReplacements() {
        TerraformDegradation.putReplacement(null, Blocks.f_50652_.m_49966_(), 30);
        TerraformDegradation.putReplacement(Blocks.f_50069_, Blocks.f_50652_.m_49966_());
        TerraformDegradation.putReplacement(Blocks.f_50652_, Blocks.f_50493_.m_49966_(), 10);
        TerraformDegradation.putReplacement(Blocks.f_50652_, Blocks.f_49991_.m_49966_(), 30);
        TerraformDegradation.putReplacement(Blocks.f_50353_, Blocks.f_50090_.m_49966_(), 10000);
        TerraformDegradation.putReplacement(Blocks.f_50493_, Blocks.f_50134_.m_49966_(), 30);
        TerraformDegradation.putReplacement(Blocks.f_50034_, Blocks.f_50134_.m_49966_(), 20);
        TerraformDegradation.putReplacement(Blocks.f_50195_, Blocks.f_50134_.m_49966_(), 5);
        TerraformDegradation.putReplacement(Blocks.f_50493_, Blocks.f_49992_.m_49966_());
        TerraformDegradation.putReplacement(Blocks.f_50034_, Blocks.f_49992_.m_49966_());
        TerraformDegradation.putReplacement(Blocks.f_50195_, Blocks.f_49992_.m_49966_());
        TerraformDegradation.putReplacement(Blocks.f_50493_, Blocks.f_50129_.m_49966_(), 20);
        TerraformDegradation.putReplacement(Blocks.f_50034_, Blocks.f_49992_.m_49966_(), 20);
        TerraformDegradation.putReplacement(Blocks.f_50195_, Blocks.f_49992_.m_49966_(), 20);
        TerraformDegradation.putReplacement(Blocks.f_50134_, RegistryEntries.BLOCK_INFESTED_NETHER_NETHERRACK.m_49966_(), 50);
        TerraformDegradation.putReplacement(Blocks.f_49992_, null);
        TerraformDegradation.putReplacement(Blocks.f_49990_, null);
    }

    private static final void putReplacement(Block key, BlockState value) {
        TerraformDegradation.putReplacement(key, value, 0);
    }

    private static final void putReplacement(Block key, BlockState value, int chance) {
        Map<BlockState, Integer> mapValue = TERRAFORMATIONS.get(key);
        if (mapValue == null) {
            mapValue = new HashMap<BlockState, Integer>();
            TERRAFORMATIONS.put(key, mapValue);
        }
        mapValue.put(value, chance);
    }

    public TerraformDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    protected BlockState getReplacement(Block block) {
        Object[] keys;
        BlockState holder;
        Integer chance;
        Map<BlockState, Integer> mapValue;
        if (TERRAFORMATIONS.isEmpty()) {
            TerraformDegradation.generateReplacements();
        }
        if ((mapValue = TERRAFORMATIONS.get(block)) == null) {
            mapValue = TERRAFORMATIONS.get(null);
        }
        if (mapValue != null && ((chance = mapValue.get(holder = (BlockState)(keys = mapValue.keySet().toArray())[random.nextInt(keys.length)])) == null || chance == 0 || random.nextInt(chance) == 0)) {
            return holder;
        }
        return null;
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        BlockPos blockPos;
        Level world = degradable.getDegradationWorld();
        Block block = world.m_8055_(blockPos = LocationHelpers.getRandomPointInSphere((BlockPos)degradable.getLocation(), (int)degradable.getRadius())).m_60734_();
        BlockState replace = this.getReplacement(block);
        if (replace != null && !degradable.getLocation().equals((Object)blockPos) && world.m_7702_(blockPos) == null) {
            if (replace.m_60734_() == null) {
                world.m_7471_(blockPos, false);
            } else if (replace.m_60800_((BlockGetter)world, blockPos) > 0.0f) {
                world.m_7731_(blockPos, replace, 3);
            }
        }
    }
}

