/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodchest;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairAction;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockBloodChestConfig;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.AnvilRepairAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.DamageableItemRepairAction;

public class BloodChestRepairActionRegistry
implements IBloodChestRepairActionRegistry {
    private final List<IBloodChestRepairAction> repairActions = new LinkedList<IBloodChestRepairAction>();

    public BloodChestRepairActionRegistry() {
        this.register(new DamageableItemRepairAction());
        this.register(new AnvilRepairAction());
    }

    @Override
    public void register(IBloodChestRepairAction repairAction) {
        this.repairActions.add(repairAction);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        if (this.isNotBlacklisted(itemStack)) {
            for (IBloodChestRepairAction action : this.repairActions) {
                if (!action.isItemValidForSlot(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int canRepair(ItemStack itemStack, int tick) {
        for (int i = 0; i < this.repairActions.size(); ++i) {
            if (!this.repairActions.get(i).canRepair(itemStack, tick)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Pair<Float, ItemStack> repair(ItemStack itemStack, RandomSource random, int actionID, boolean doAction, boolean isBulk) {
        return this.repairActions.get(actionID).repair(itemStack, random, doAction, isBulk);
    }

    protected boolean isNotBlacklisted(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (String name : BlockBloodChestConfig.itemBlacklist) {
            if (!ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().matches(name)) continue;
            return false;
        }
        return true;
    }
}

