/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimed;
import org.cyclops.evilcraft.entity.item.EntityLightningGrenade;

public class BlockLightningBomb
extends Block {
    public static final BooleanProperty PRIMED = BooleanProperty.m_61465_((String)"primed");

    public BlockLightningBomb(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PRIMED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(false));
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos blockPos, BlockState oldState, boolean isMoving) {
        super.m_6807_(blockState, world, blockPos, oldState, isMoving);
        if (world.m_46753_(blockPos)) {
            this.m_6786_((LevelAccessor)world, blockPos, (BlockState)blockState.m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.m_7471_(blockPos, false);
        }
    }

    public void m_6861_(BlockState blockState, Level world, BlockPos blockPos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(blockState, world, blockPos, blockIn, fromPos, isMoving);
        if (world.m_46753_(blockPos)) {
            this.m_6786_((LevelAccessor)world, blockPos, (BlockState)blockState.m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.m_7471_(blockPos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        if (!world.m_5776_()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed(world, (float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 0.5f, (float)blockPos.m_123343_() + 0.5f, explosion.m_46079_());
            entityprimed.m_32085_(world.f_46441_.m_188503_(entityprimed.m_32100_() / 4) + entityprimed.m_32100_() / 8);
            world.m_7967_((Entity)entityprimed);
            world.m_7471_(blockPos, false);
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        super.m_6786_(world, blockPos, blockState);
        this.primeBomb(world, blockPos, blockState, null);
    }

    public void primeBomb(LevelAccessor world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity placer) {
        if (!world.m_5776_() && ((Boolean)blockState.m_61143_((Property)PRIMED)).booleanValue()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed((Level)world, (float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 0.5f, (float)blockPos.m_123343_() + 0.5f, placer);
            world.m_7967_((Entity)entityprimed);
            world.m_5594_(null, blockPos, SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (!(player.m_21120_(hand).m_41619_() || player.m_21120_(hand).m_41720_() != Items.f_42409_ && player.m_21120_(hand).m_41720_() != Items.f_42613_)) {
            this.primeBomb((LevelAccessor)world, blockPos, (BlockState)this.m_49966_().m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true)), (LivingEntity)player);
            world.m_7471_(blockPos, false);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, e -> {});
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, blockPos, player, hand, p_225533_6_);
    }

    public void m_141947_(Level world, BlockPos blockPos, BlockState blockState, Entity entity) {
        BlockState primedState = (BlockState)this.m_49966_().m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true));
        if (entity instanceof AbstractArrow && !world.m_5776_()) {
            AbstractArrow entityarrow = (AbstractArrow)entity;
            if (entityarrow.m_6060_()) {
                this.primeBomb((LevelAccessor)world, blockPos, primedState, entityarrow.m_37282_() instanceof LivingEntity ? (LivingEntity)entityarrow.m_37282_() : null);
                world.m_7471_(blockPos, false);
            }
        } else if (entity instanceof EntityLightningGrenade && !world.m_5776_()) {
            EntityLightningGrenade entitygrenade = (EntityLightningGrenade)entity;
            this.primeBomb((LevelAccessor)world, blockPos, primedState, entitygrenade.m_37282_() instanceof LivingEntity ? (LivingEntity)entitygrenade.m_37282_() : null);
            world.m_7471_(blockPos, false);
        }
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }
}

