/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.storage.DimChestStorage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenChest {
    private Frequency freq;
    private boolean open;

    public OpenChest(FriendlyByteBuf buf) {
        this.freq = Frequency.readFromPacket(buf);
        this.open = buf.readBoolean();
    }

    public OpenChest(Frequency freq, boolean open) {
        this.freq = freq;
        this.open = open;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.freq.writeToPacket(buf);
        buf.writeBoolean(this.open);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ((DimChestStorage)DimStorageManager.instance(true).getStorage(this.freq, "item")).setClientOpen(this.open ? 1 : 0));
        ctx.get().setPacketHandled(true);
    }
}

