/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import java.util.List;
import net.brnbrd.delightful.common.item.knife.DelightfulKnifeItem;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatKnifeItem
extends DelightfulKnifeItem {
    private final String modid;
    private final ChatFormatting[] formatting;

    public CompatKnifeItem(String modid, @Nullable TagKey<Item> tag, Tier tier, Item.Properties properties, ChatFormatting ... formatting) {
        super(tag, tier, properties);
        this.modid = modid;
        this.formatting = formatting;
    }

    public String getModid() {
        return this.modid;
    }

    public boolean isLoaded() {
        return Mods.loaded(this.getModid());
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isLoaded();
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        if (!this.isLoaded()) {
            comps.add((Component)Component.m_237115_((String)"tooltip.requires_modid"));
            return;
        }
        super.m_7373_(stack, level, comps, pIsAdvanced);
        if (this.isEnabled() && !this.getTools().isEmpty()) {
            comps.addAll(this.getTools());
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return this.isEnabled() && this.formatting.length > 0 ? super.m_7626_(stack).m_6881_().m_130944_(this.formatting) : super.m_7626_(stack);
    }

    @Override
    protected boolean m_220152_(@NotNull CreativeModeTab ct) {
        return super.m_220152_(ct) && this.isEnabled();
    }
}

