/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

public class NbtPathStringParser {
    public static StringParseResult parse(String source, int pos) {
        if (pos >= source.length() || source.charAt(pos) != '\"') {
            return StringParseResult.fail();
        }
        StringBuilder resultBuilder = new StringBuilder();
        int currentPos = pos + 1;
        block7: while (currentPos < source.length()) {
            char character = source.charAt(currentPos);
            ++currentPos;
            switch (character) {
                case '\\': {
                    if (currentPos >= source.length()) {
                        return StringParseResult.fail();
                    }
                    char escapeName = source.charAt(currentPos);
                    ++currentPos;
                    switch (escapeName) {
                        case '\"': 
                        case '\\': {
                            resultBuilder.append(escapeName);
                            continue block7;
                        }
                    }
                    return StringParseResult.fail();
                }
                case '\"': {
                    return StringParseResult.success(currentPos - pos, resultBuilder.toString());
                }
            }
            resultBuilder.append(character);
        }
        return StringParseResult.fail();
    }

    public static class StringParseResult {
        private static StringParseResult FAIL = new StringParseResult(false, 0, "");
        private final boolean success;
        private final int consumed;
        private final String result;

        public StringParseResult(boolean success, int consumed, String result) {
            this.success = success;
            this.consumed = consumed;
            this.result = result;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getConsumed() {
            return this.consumed;
        }

        public String getResult() {
            return this.result;
        }

        private static StringParseResult success(int consumed, String result) {
            return new StringParseResult(true, consumed, result);
        }

        private static StringParseResult fail() {
            return FAIL;
        }
    }
}

