/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.handler.codec.EncoderException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.SyncedGuiVariable;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonAction;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonClickAcceptorServer;
import org.cyclops.cyclopscore.inventory.slot.SlotArmor;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ValueNotifyPacket;

public abstract class ContainerExtended
extends AbstractContainerMenu
implements IContainerButtonClickAcceptorServer<ContainerExtended>,
IValueNotifier,
IValueNotifiable {
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    protected static final int ITEMBOX = 18;
    private final Map<String, IContainerButtonAction<ContainerExtended>> buttonActions = Maps.newHashMap();
    private final Map<Integer, CompoundTag> values = Maps.newHashMap();
    private final List<SyncedGuiVariable<?>> syncedGuiVariables = Lists.newArrayList();
    private int nextValueId = 0;
    private IValueNotifiable guiValueListener = null;
    private Container playerIInventory;
    protected final Player player;
    protected int offsetX = 0;
    protected int offsetY = 0;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();

    public ContainerExtended(@Nullable MenuType<?> type, int id, Inventory inventory) {
        super(type, id);
        this.playerIInventory = inventory;
        this.player = inventory.f_35978_;
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.f_19853_.m_5776_()) {
            for (SyncedGuiVariable<?> syncedGuiVariable : this.syncedGuiVariables) {
                syncedGuiVariable.detectAndSendChanges();
            }
        }
    }

    public void setGuiValueListener(IValueNotifiable listener) {
        this.guiValueListener = listener;
    }

    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
        if (!this.player.m_20193_().m_5776_()) {
            this.initializeValues();
        }
    }

    protected void initializeValues() {
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y);
    }

    static void setSlotPos(Slot slot, String fieldName, int newValue) {
        try {
            Field field = ObfuscationReflectionHelper.findField(Slot.class, (String)fieldName);
            field.setAccessible(true);
            field.set(slot, newValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setSlotPosX(Slot slot, int newValue) {
        ContainerExtended.setSlotPos(slot, "f_40220_", newValue);
    }

    public static void setSlotPosY(Slot slot, int newValue) {
        ContainerExtended.setSlotPos(slot, "f_40221_", newValue);
    }

    protected Slot m_38897_(Slot slot) {
        ContainerExtended.setSlotPosX(slot, slot.f_40220_ + this.offsetX);
        ContainerExtended.setSlotPosY(slot, slot.f_40221_ + this.offsetY);
        return super.m_38897_(slot);
    }

    protected void addInventory(Container inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.m_38897_(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(Inventory inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((Container)inventory, 0, offsetX, offsetY + 58, 1, cols);
        this.addInventory((Container)inventory, cols, offsetX, offsetY, rows, cols);
    }

    protected void addPlayerArmorInventory(Inventory inventory, int offsetX, int offsetY) {
        for (int k = 0; k < 4; ++k) {
            EquipmentSlot equipmentSlot = EQUIPMENT_SLOTS[k];
            this.m_38897_(new SlotArmor((Container)inventory, 36 + (3 - k), offsetX, offsetY + k * 18, inventory.f_35978_, equipmentSlot));
        }
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public ItemStack m_7648_(Player player, int slotID) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_().m_41777_();
            stack = stackInSlot.m_41777_();
            if (slotID < slots ? !this.m_38903_(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.f_38839_.size(), true), true) : !this.m_38903_(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_5852_(stackInSlot);
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return stack;
    }

    protected boolean m_38903_(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.m_41741_();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.m_41753_()) {
            while (stack.m_41613_() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                int maxSlotSize = Math.min(slot.m_6641_(), maxStack);
                existingStack = slot.m_7993_().m_41777_();
                if (slot.m_5857_(stack) && !existingStack.m_41619_() && existingStack.m_41720_() == stack.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.m_41613_() + stack.m_41613_();
                    if (existingSize <= maxSlotSize) {
                        stack.m_41764_(0);
                        existingStack.m_41764_(existingSize);
                        slot.m_5852_(existingStack);
                        successful = true;
                    } else if (existingStack.m_41613_() < maxSlotSize) {
                        stack.m_41774_(maxSlotSize - existingStack.m_41613_());
                        existingStack.m_41764_(maxSlotSize);
                        slot.m_5852_(existingStack);
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.m_41613_() > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (stack.m_41613_() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                existingStack = slot.m_7993_().m_41777_();
                if (slot.m_5857_(stack) && existingStack.m_41619_()) {
                    int placedAmount = Math.min(stack.m_41613_(), slot.m_6641_());
                    ItemStack toPut = stack.m_41777_();
                    toPut.m_41764_(placedAmount);
                    slot.m_5852_(toPut);
                    stack.m_41774_(placedAmount);
                    successful = true;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public Container getPlayerIInventory() {
        return this.playerIInventory;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot = slotId < 0 ? null : (Slot)this.f_38839_.get(slotId);
        Inventory inventory = player.m_150109_();
        if (clickType == ClickType.QUICK_CRAFT) {
            int i = this.quickcraftStatus;
            this.quickcraftStatus = ContainerExtended.m_38947_((int)dragType);
            if ((i != 1 || this.quickcraftStatus != 2) && i != this.quickcraftStatus) {
                this.m_38951_();
            } else if (this.m_142621_().m_41619_()) {
                this.m_38951_();
            } else if (this.quickcraftStatus == 0) {
                this.quickcraftType = ContainerExtended.m_38928_((int)dragType);
                if (ContainerExtended.m_38862_((int)this.quickcraftType, (Player)player)) {
                    this.quickcraftStatus = 1;
                    this.quickcraftSlots.clear();
                } else {
                    this.m_38951_();
                }
            } else if (this.quickcraftStatus == 1) {
                ItemStack itemstack = this.m_142621_();
                if (ContainerExtended.m_38899_((Slot)slot, (ItemStack)itemstack, (boolean)true) && slot.m_5857_(itemstack) && (this.quickcraftType == 2 || itemstack.m_41613_() > this.quickcraftSlots.size()) && this.m_5622_(slot)) {
                    this.quickcraftSlots.add(slot);
                }
            } else if (this.quickcraftStatus == 2) {
                if (!this.quickcraftSlots.isEmpty()) {
                    int phantomCount = 0;
                    if (this.quickcraftSlots.size() == 1) {
                        int l = this.quickcraftSlots.iterator().next().f_40219_;
                        this.m_38951_();
                        this.m_150399_(l, this.quickcraftType, ClickType.PICKUP, player);
                        return;
                    }
                    ItemStack itemstack3 = this.m_142621_().m_41777_();
                    int j1 = this.m_142621_().m_41613_();
                    for (Slot slot1 : this.quickcraftSlots) {
                        ItemStack itemstack1 = this.m_142621_();
                        if (slot1 == null || !ContainerExtended.m_38899_((Slot)slot1, (ItemStack)itemstack1, (boolean)true) || !slot1.m_5857_(itemstack1) || this.quickcraftType != 2 && itemstack1.m_41613_() < this.quickcraftSlots.size() || !this.m_5622_(slot1)) continue;
                        ItemStack itemstack2 = itemstack3.m_41777_();
                        int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                        ContainerExtended.m_38922_(this.quickcraftSlots, (int)this.quickcraftType, (ItemStack)itemstack2, (int)j);
                        int k = Math.min(itemstack2.m_41741_(), slot1.m_5866_(itemstack2));
                        if (itemstack2.m_41613_() > k) {
                            itemstack2.m_41764_(k);
                        }
                        j1 -= itemstack2.m_41613_() - j;
                        slot1.m_5852_(itemstack2);
                        if (!(slot1 instanceof SlotExtended) || !((SlotExtended)slot1).isPhantom()) continue;
                        phantomCount += itemstack2.m_41613_() - j;
                    }
                    itemstack3.m_41764_(j1 + phantomCount);
                    this.m_142503_(itemstack3);
                }
                this.m_38951_();
            } else {
                this.m_38951_();
            }
        } else if (this.quickcraftStatus != 0) {
            this.m_38951_();
        } else if (slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            this.slotClickPhantom(slot, dragType, clickType, player);
        } else {
            super.m_150399_(slotId, dragType, clickType, player);
        }
    }

    protected void m_38951_() {
        super.m_38951_();
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickType, Player player) {
        ItemStack stack = ItemStack.f_41583_;
        if (mouseButton == 2) {
            if (((SlotExtended)slot).isAdjustable()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            slot.m_6654_();
            ItemStack stackSlot = slot.m_7993_();
            ItemStack stackHeld = this.m_142621_();
            if (!stackSlot.m_41619_()) {
                stack = stackSlot.m_41777_();
            }
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            } else if (stackHeld.m_41619_()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.m_142406_(player, this.m_142621_());
            } else if (slot.m_5857_(stackHeld)) {
                if (ItemMatch.areItemStacksEqual((ItemStack)stackSlot, (ItemStack)stackHeld, (int)5)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.m_41613_() + 1) / 2 : stackSlot.m_41613_() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.m_41613_() - 1 : stackSlot.m_41613_() + 1;
        }
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        stackSlot.m_41764_(stackSize);
        if (stackSlot.m_41613_() <= 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(stackSize);
        slot.m_5852_(phantomStack);
    }

    @Override
    public void putButtonAction(String buttonId, IContainerButtonAction<ContainerExtended> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean onButtonClick(String buttonId) {
        IContainerButtonAction<ContainerExtended> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this);
            return true;
        }
        return false;
    }

    protected int getNextValueId() {
        return this.nextValueId++;
    }

    @Override
    public void setValue(int valueId, CompoundTag value) {
        if (!this.values.containsKey(valueId) || !this.values.get(valueId).equals((Object)value)) {
            try {
                if (!this.player.f_19853_.m_5776_()) {
                    CyclopsCore._instance.getPacketHandler().sendToPlayer(new ValueNotifyPacket(this.m_6772_(), valueId, value), (ServerPlayer)this.player);
                } else {
                    CyclopsCore._instance.getPacketHandler().sendToServer(new ValueNotifyPacket(this.m_6772_(), valueId, value));
                }
                this.values.put(valueId, value);
            }
            catch (EncoderException e) {
                CyclopsCore.clog(Level.WARN, e.getMessage());
            }
        }
    }

    @Override
    public CompoundTag getValue(int valueId) {
        return this.values.get(valueId);
    }

    @Override
    public Set<Integer> getValueIds() {
        return this.values.keySet();
    }

    @Override
    public MenuType<?> getValueNotifiableType() {
        return this.m_6772_();
    }

    @Override
    public void onUpdate(int valueId, CompoundTag value) {
        this.values.put(valueId, value);
        if (this.guiValueListener != null) {
            this.guiValueListener.onUpdate(valueId, value);
        }
    }

    public <T> Supplier<T> registerSyncedVariable(Class<T> clazz, Supplier<T> serverValueSupplier) {
        SyncedGuiVariable<T> variable = new SyncedGuiVariable<T>(this, clazz, serverValueSupplier);
        this.syncedGuiVariables.add(variable);
        return variable;
    }
}

