/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final String level;
    private final BlockPos blockPos;
    private WeakReference<Level> worldReference;
    private static final LoadingCache<String, ResourceKey<Level>> CACHE_WORLD_KEYS = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ResourceKey<Level>>(){

        public ResourceKey<Level> load(String key) {
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(key));
        }
    });

    private DimPos(String dimension, BlockPos blockPos, Level world) {
        this.level = dimension;
        this.blockPos = blockPos;
        this.worldReference = world != null && world.m_5776_() ? new WeakReference<Level>(world) : null;
    }

    private DimPos(String world, BlockPos blockPos) {
        this(world, blockPos, null);
    }

    public ResourceKey<Level> getLevelKey() {
        return (ResourceKey)CACHE_WORLD_KEYS.get((Object)this.getLevel());
    }

    @Nullable
    public Level getLevel(boolean forceLoad) {
        if (this.worldReference == null) {
            if (MinecraftHelpers.isClientSideThread()) {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world != null && world.m_46472_().m_135782_().toString().equals(this.getLevel())) {
                    this.worldReference = new WeakReference<ClientLevel>(world);
                    return (Level)this.worldReference.get();
                }
                return null;
            }
            return ServerLifecycleHooks.getCurrentServer().m_129880_(this.getLevelKey());
        }
        Level world = (Level)this.worldReference.get();
        if (world == null) {
            world = ServerLifecycleHooks.getCurrentServer().m_129880_(this.getLevelKey());
            this.worldReference = new WeakReference<Level>(world);
        }
        return world;
    }

    public boolean isLoaded() {
        Level world = this.getLevel(false);
        return world != null && world.m_46805_(this.getBlockPos());
    }

    @Override
    public int compareTo(DimPos o) {
        int compareDim = this.getLevel().compareTo(o.getLevel());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    public boolean equals(Object o) {
        return o instanceof DimPos && this.compareTo((DimPos)o) == 0;
    }

    public int hashCode() {
        return 31 * this.getLevel().hashCode() + this.getBlockPos().hashCode();
    }

    public DimPos withPosition(BlockPos pos) {
        return new DimPos(this.level, pos, this.worldReference == null ? null : (Level)this.worldReference.get());
    }

    public static DimPos of(Level world, BlockPos blockPos) {
        return DimPos.of((ResourceKey<Level>)world.m_46472_(), blockPos);
    }

    public static DimPos of(ResourceKey<Level> world, BlockPos blockPos) {
        return new DimPos(world.m_135782_().toString(), blockPos);
    }

    public static DimPos of(String level, BlockPos blockPos) {
        return new DimPos(level, blockPos);
    }

    public String getLevel() {
        return this.level;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public WeakReference<Level> getWorldReference() {
        return this.worldReference;
    }

    public void setWorldReference(WeakReference<Level> worldReference) {
        this.worldReference = worldReference;
    }

    public String toString() {
        return "DimPos(level=" + this.getLevel() + ", blockPos=" + this.getBlockPos() + ", worldReference=" + this.getWorldReference() + ")";
    }
}

