/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;

public class RetextureableBlockModelWrapper
extends BlockModel {
    private final BlockModel model;

    public RetextureableBlockModelWrapper(BlockModel model) {
        super(model.getParentLocation(), model.m_111436_(), model.f_111417_, model.f_111424_, model.m_111479_(), model.m_111491_(), model.m_111484_());
        this.model = model;
        this.f_111416_ = model.f_111416_;
        this.f_111418_ = model.f_111418_;
    }

    public RetextureableBlockModelWrapper retexture(ImmutableMap<String, String> textures) {
        if (textures.isEmpty()) {
            return this;
        }
        ArrayList elements = Lists.newArrayList();
        for (BlockElement part : this.model.m_111436_()) {
            elements.add(new BlockElement(part.f_111308_, part.f_111309_, (Map)Maps.newHashMap((Map)part.f_111310_), part.f_111311_, part.f_111312_));
        }
        BlockModel newModel = new BlockModel(this.model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)this.model.f_111417_), this.model.m_111476_(), this.model.m_111479_(), this.model.m_111491_(), (List)Lists.newArrayList((Iterable)this.model.m_111484_()));
        newModel.f_111416_ = this.model.f_111416_;
        newModel.f_111418_ = this.model.f_111418_;
        HashSet removed = Sets.newHashSet();
        for (Map.Entry e : textures.entrySet()) {
            if ("".equals(e.getValue())) {
                removed.add((String)e.getKey());
                newModel.f_111417_.remove(e.getKey());
                continue;
            }
            newModel.f_111417_.put((String)e.getKey(), Either.left((Object)new Material(TextureAtlas.f_118259_, new ResourceLocation((String)e.getValue()))));
        }
        HashMap remapped = Maps.newHashMap();
        for (Map.Entry e : newModel.f_111417_.entrySet()) {
            String key;
            Optional right = ((Either)e.getValue()).right();
            if (!right.isPresent() || !((String)right.get()).startsWith("#") || !newModel.f_111417_.containsKey(key = ((String)right.get()).substring(1))) continue;
            remapped.put((String)e.getKey(), (Either)newModel.f_111417_.get(key));
        }
        newModel.f_111417_.putAll(remapped);
        for (BlockElement part : newModel.m_111436_()) {
            part.f_111310_.entrySet().removeIf(entry -> removed.contains(((BlockElementFace)entry.getValue()).f_111356_));
        }
        return new RetextureableBlockModelWrapper(newModel);
    }
}

