/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.biome;

import com.epherical.croptopia.CroptopiaForge;
import com.epherical.croptopia.registry.GeneratorRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public record CropModifier(GenerationStep.Decoration step, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)CroptopiaForge.createIdentifier("crops"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"croptopia");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!biome.m_203656_(BiomeTags.f_207603_) && !biome.m_203656_(Tags.Biomes.IS_UNDERGROUND) && phase == BiomeModifier.Phase.ADD) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            generation.m_204201_(this.step, this.feature);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<CropModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.comapFlatMap(CropModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(CropModifier::step), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(CropModifier::feature)).apply((Applicative)builder, CropModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }

    public static void register(DeferredRegister<BiomeModifier> biomeSerializer) {
        CropModifier modifier = new CropModifier(GenerationStep.Decoration.VEGETAL_DECORATION, GeneratorRegistry.RANDOM_CROP_PLACED);
        biomeSerializer.register("random_crops", () -> modifier);
    }
}

