/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.InventoryBlock;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBotanyPot
extends InventoryBlock
implements SimpleWaterloggedBlock,
IBindRenderLayer {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final BlockBehaviour.Properties DEFAULT_PROPERTIES = BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76413_).m_60913_(1.25f, 4.2f).m_60955_().m_60953_(state -> (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_));
    private final boolean hasInventory;

    public BlockBotanyPot(boolean hasInventory) {
        this(DEFAULT_PROPERTIES, hasInventory);
    }

    public BlockBotanyPot(BlockBehaviour.Properties properties, boolean hasInventory) {
        super(properties);
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(0));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        this.m_49959_(defaultState);
        this.hasInventory = hasInventory;
    }

    public boolean hasInventory() {
        return this.hasInventory;
    }

    public RenderShape m_7514_(BlockState $$0) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos placedPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(placedPos);
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityBotanyPot) {
            BlockEntityBotanyPot pot = (BlockEntityBotanyPot)blockEntity;
            n = pot.getComparatorLevel();
        } else {
            n = 0;
        }
        return n;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_, BlockStateProperties.f_61422_, BlockStateProperties.f_61374_});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityBotanyPot((BlockEntityType)BlockEntityBotanyPot.POT_TYPE.get(), pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityBotanyPot) {
            Fertilizer fertilizer;
            BlockEntityBotanyPot potEntity = (BlockEntityBotanyPot)blockEntity;
            ItemStack heldStack = player.m_21120_(hand);
            if (potEntity.areGrowthConditionsMet() && potEntity.getGrowthTime() > 0 && !potEntity.doneGrowing && (fertilizer = BotanyPotHelper.findFertilizer(state, world, pos, player, hand, heldStack, potEntity)) != null) {
                fertilizer.apply(state, world, pos, player, hand, heldStack, potEntity);
                return InteractionResult.CONSUME;
            }
            PotInteraction interaction = BotanyPotHelper.findPotInteraction(state, world, pos, player, hand, heldStack, potEntity);
            if (interaction != null) {
                interaction.apply(state, world, pos, player, hand, heldStack, potEntity);
                return InteractionResult.CONSUME;
            }
            if (!player.m_6047_() && !potEntity.isHopper() && potEntity.doneGrowing && potEntity.getCrop() != null) {
                if (!world.f_46443_) {
                    for (ItemStack drop : BotanyPotHelper.generateDrop(potEntity.rng, world, pos, potEntity, potEntity.getCrop())) {
                        BlockBotanyPot.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                    }
                    potEntity.resetGrowth();
                }
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Services.INVENTORY_HELPER.openMenu(serverPlayer, (MenuProvider)potEntity, buf -> Serializers.BLOCK_POS.toByteBuf(buf, (Object)pos));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hitResult);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldLevel, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockBotanyPot.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityBotanyPot.POT_TYPE.get()), BlockEntityBotanyPot::tickPot);
    }

    public RenderType getRenderLayerToBind() {
        return RenderType.m_110463_();
    }
}

