/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.displaystate.AbstractSimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.DisplayStateSerializer;
import net.darkhax.botanypots.data.displaystate.math.AxisAlignedRotation;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleDisplayState
extends AbstractSimpleDisplayState {
    public static final ResourceLocation ID = new ResourceLocation("botanypots", "simple");
    public static final DisplayStateSerializer<SimpleDisplayState> SERIALIZER = new Serializer();
    private BlockState state;

    public SimpleDisplayState(BlockState state) {
        this(state, Optional.empty(), Optional.empty(), new ArrayList<AxisAlignedRotation>(), false);
    }

    public SimpleDisplayState(BlockState state, Optional<Vector3f> scale, Optional<Vector3f> offset, List<AxisAlignedRotation> rotations, boolean renderFluid) {
        super(scale, offset, rotations, renderFluid);
        this.state = state;
    }

    @Override
    public BlockState getRenderState(float progress) {
        return this.state;
    }

    @Override
    public DisplayStateSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements DisplayStateSerializer<SimpleDisplayState> {
        public SimpleDisplayState fromJSON(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                BlockState state = (BlockState)Serializers.BLOCK_STATE.fromJSON((JsonElement)obj);
                Optional scale = Serializers.VECTOR_3F.fromJSONOptional(obj, "scale");
                Optional offset = Serializers.VECTOR_3F.fromJSONOptional(obj, "offset");
                List rotations = AxisAlignedRotation.SERIALIZER.fromJSONList(obj, "rotation", new ArrayList());
                boolean renderFluid = (Boolean)Serializers.BOOLEAN.fromJSON(obj, "renderFluid", (Object)false);
                return new SimpleDisplayState(state, scale, offset, rotations, renderFluid);
            }
            throw new JsonParseException("Expected a JSON object.");
        }

        public JsonElement toJSON(SimpleDisplayState toWrite) {
            JsonObject obj = new JsonObject();
            Serializers.BLOCK_STATE.toJSON(obj, "state", (Object)toWrite.state);
            Serializers.VECTOR_3F.toJSONOptional(obj, "scale", toWrite.scale);
            Serializers.VECTOR_3F.toJSONOptional(obj, "offset", toWrite.offset);
            AxisAlignedRotation.SERIALIZER.toJSONList(obj, "rotation", toWrite.rotations);
            Serializers.BOOLEAN.toJSON(obj, "renderFluid", (Object)toWrite.renderFluid);
            return obj;
        }

        public SimpleDisplayState fromByteBuf(FriendlyByteBuf buffer) {
            BlockState state = (BlockState)Serializers.BLOCK_STATE.fromByteBuf(buffer);
            Optional scale = Serializers.VECTOR_3F.fromByteBufOptional(buffer);
            Optional offset = Serializers.VECTOR_3F.fromByteBufOptional(buffer);
            List rotations = AxisAlignedRotation.SERIALIZER.fromByteBufList(buffer);
            boolean renderFluid = (Boolean)Serializers.BOOLEAN.fromByteBuf(buffer);
            return new SimpleDisplayState(state, scale, offset, rotations, renderFluid);
        }

        public void toByteBuf(FriendlyByteBuf buffer, SimpleDisplayState toWrite) {
            Serializers.BLOCK_STATE.toByteBuf(buffer, (Object)toWrite.state);
            Serializers.VECTOR_3F.toByteBufOptional(buffer, toWrite.scale);
            Serializers.VECTOR_3F.toByteBufOptional(buffer, toWrite.offset);
            AxisAlignedRotation.SERIALIZER.toByteBufList(buffer, toWrite.rotations);
            Serializers.BOOLEAN.toByteBuf(buffer, (Object)toWrite.renderFluid);
        }

        public Tag toNBT(SimpleDisplayState toWrite) {
            return null;
        }

        public SimpleDisplayState fromNBT(Tag nbt) {
            return null;
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }
    }
}

