/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class PureDaisyProvider
extends BotaniaRecipeProvider {
    public PureDaisyProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("livingrock"), StateIngredientHelper.of(Blocks.f_50069_), BotaniaBlocks.livingrock.m_49966_()));
        consumer.accept(new StateCopyingRecipe(PureDaisyProvider.id("livingwood"), StateIngredientHelper.of((TagKey<Block>)BlockTags.f_13106_), BotaniaBlocks.livingwoodLog));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("cobblestone"), StateIngredientHelper.of(Blocks.f_50134_), Blocks.f_50652_.m_49966_()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("end_stone_to_cobbled_deepslate"), StateIngredientHelper.of(Blocks.f_50259_), Blocks.f_152551_.m_49966_(), 150, ResourceLocationHelper.prefix("ender_air_release")));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("sand"), StateIngredientHelper.of(Blocks.f_50135_), Blocks.f_49992_.m_49966_()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("packed_ice"), StateIngredientHelper.of(Blocks.f_50126_), Blocks.f_50354_.m_49966_()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("blue_ice"), StateIngredientHelper.of(Blocks.f_50354_), Blocks.f_50568_.m_49966_()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("obsidian"), StateIngredientHelper.of(BotaniaBlocks.blazeBlock), Blocks.f_50080_.m_49966_()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("snow_block"), StateIngredientHelper.of(Blocks.f_49990_), Blocks.f_50127_.m_49966_()));
    }

    public String m_6055_() {
        return "Botania Pure Daisy recipes";
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("pure_daisy/" + path);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        public static final int DEFAULT_TIME = 150;
        protected final ResourceLocation id;
        protected final StateIngredient input;
        protected final BlockState outputState;
        protected final int time;
        @Nullable
        private final ResourceLocation function;

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state) {
            this(id, input, state, 150);
        }

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time) {
            this(id, input, state, time, null);
        }

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time, @Nullable ResourceLocation function) {
            Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
            this.id = id;
            this.input = input;
            this.outputState = state;
            this.time = time;
            this.function = function;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.add("output", (JsonElement)StateIngredientHelper.serializeBlockState(this.outputState));
            if (this.time != 150) {
                json.addProperty("time", (Number)this.time);
            }
            if (this.function != null) {
                json.addProperty("success_function", this.function.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    protected static class StateCopyingRecipe
    extends FinishedRecipe {
        public StateCopyingRecipe(ResourceLocation id, StateIngredient input, Block block) {
            super(id, input, block.m_49966_());
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.addProperty("output", Registry.f_122824_.m_7981_((Object)this.outputState.m_60734_()).toString());
            if (this.time != 150) {
                json.addProperty("time", (Number)this.time);
            }
        }

        @Override
        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.COPYING_PURE_DAISY_SERIALIZER;
        }
    }
}

