/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.crafting.AssemblyHaloContainer;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class AssemblyHaloItem
extends Item {
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow0.png");
    private static final ItemStack craftingTable = new ItemStack((ItemLike)Blocks.f_50091_);
    public static final int SEGMENTS = 12;
    private static final String TAG_LAST_CRAFTING = "lastCrafting";
    private static final String TAG_STORED_RECIPE_PREFIX = "storedRecipe";
    private static final String TAG_EQUIPPED = "equipped";
    private static final String TAG_ROTATION_BASE = "rotationBase";

    public AssemblyHaloItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            int segment = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(world, stack, segment);
            if (segment == 0) {
                ContainerLevelAccess wp = ContainerLevelAccess.m_39289_((Level)world, (BlockPos)BlockPos.f_121853_);
                player.m_5893_((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> new AssemblyHaloContainer(windowId, playerInv, wp), stack.m_41786_()));
            } else if (recipe == null) {
                Recipe<CraftingContainer> lastRecipe = AssemblyHaloItem.getLastRecipe(world, stack);
                if (lastRecipe != null) {
                    AssemblyHaloItem.saveRecipe(stack, lastRecipe.m_6423_(), segment);
                }
            } else {
                this.tryCraft(player, stack, segment, true);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int pos, boolean equipped) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean eqLastTick = AssemblyHaloItem.wasEquipped(stack);
        if (!equipped && living.m_21206_() == stack) {
            equipped = true;
        }
        if (eqLastTick != equipped) {
            AssemblyHaloItem.setEquipped(stack, equipped);
        }
        if (!equipped) {
            int angles = 360;
            int segAngles = angles / 12;
            float shift = (float)segAngles / 2.0f;
            AssemblyHaloItem.setRotationBase(stack, AssemblyHaloItem.getCheckingAngle((LivingEntity)entity) - shift);
        }
    }

    private static boolean hasRoomFor(Inventory inv, ItemStack stack) {
        Inventory dummy = new Inventory(inv.f_35978_);
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            dummy.f_35974_.set(i, (Object)((ItemStack)inv.f_35974_.get(i)).m_41777_());
        }
        return dummy.m_36054_(stack.m_41777_());
    }

    private static boolean canCraftHeuristic(Player player, Recipe<CraftingContainer> recipe) {
        StackedContents accounter = new StackedContents();
        player.m_150109_().m_36010_(accounter);
        return accounter.m_36475_(recipe, null);
    }

    void tryCraft(Player player, ItemStack halo, int slot, boolean particles) {
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(player.m_9236_(), halo, slot);
        if (recipe == null) {
            return;
        }
        CraftingMenu dummy = new CraftingMenu(-999, player.m_150109_());
        CraftingContainer craftInv = (CraftingContainer)dummy.m_38853_((int)1).f_40218_;
        RecipePlacer placer = new RecipePlacer((RecipeBookMenu<CraftingContainer>)dummy);
        if (!placer.place((ServerPlayer)player, recipe)) {
            return;
        }
        if (!recipe.m_5818_((Container)craftInv, player.m_9236_())) {
            placer.m_179844_(false);
            return;
        }
        ItemStack result = recipe.m_5874_((Container)craftInv);
        if (!AssemblyHaloItem.hasRoomFor(player.m_150109_(), result)) {
            placer.m_179844_(false);
            return;
        }
        player.m_150109_().m_36054_(result);
        NonNullList remainingItems = recipe.m_7457_((Container)craftInv);
        remainingItems.forEach(s -> player.m_150109_().m_150079_(s));
        if (particles) {
            XplatAbstractions.INSTANCE.sendToTracking((Entity)player, new BotaniaEffectPacket(EffectType.HALO_CRAFT, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_19879_()));
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity living) {
        int segment = AssemblyHaloItem.getSegmentLookedAt(stack, living);
        if (segment == 0) {
            return false;
        }
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(living.m_9236_(), stack, segment);
        if (recipe != null && living.m_6144_()) {
            AssemblyHaloItem.saveRecipe(stack, null, segment);
            return true;
        }
        return false;
    }

    protected static int getSegmentLookedAt(ItemStack stack, LivingEntity living) {
        float yaw = AssemblyHaloItem.getCheckingAngle(living, AssemblyHaloItem.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 12; ++seg) {
            float calcAngle = (float)seg * (float)segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    private static float getCheckingAngle(LivingEntity living) {
        return AssemblyHaloItem.getCheckingAngle(living, 0.0f);
    }

    private static float getCheckingAngle(LivingEntity living, float base) {
        float angle;
        float yaw = Mth.m_14177_((float)living.m_146908_()) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = segAngles / 2;
        if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) < 0.0f) {
            angle = 360.0f + angle;
        }
        return angle;
    }

    @Nullable
    private static Recipe<CraftingContainer> getSavedRecipe(Level world, ItemStack halo, int position) {
        ResourceLocation id;
        String savedId = ItemNBTHelper.getString(halo, TAG_STORED_RECIPE_PREFIX + position, "");
        ResourceLocation resourceLocation = id = savedId.isEmpty() ? null : ResourceLocation.m_135820_((String)savedId);
        if (position <= 0 || position >= 12 || id == null) {
            return null;
        }
        return BotaniaRecipeTypes.getRecipes(world, RecipeType.f_44107_).get(id);
    }

    private static void saveRecipe(ItemStack halo, @Nullable ResourceLocation id, int position) {
        if (id == null) {
            ItemNBTHelper.removeEntry(halo, TAG_STORED_RECIPE_PREFIX + position);
        } else {
            ItemNBTHelper.setString(halo, TAG_STORED_RECIPE_PREFIX + position, id.toString());
        }
    }

    private static ItemStack getDisplayItem(Level world, ItemStack stack, int position) {
        if (position == 0) {
            return craftingTable;
        }
        if (position >= 12) {
            return ItemStack.f_41583_;
        }
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(world, stack, position);
        if (recipe != null) {
            return recipe.m_8043_();
        }
        return ItemStack.f_41583_;
    }

    public static void onItemCrafted(Player player, Container inv) {
        AbstractContainerMenu container = player.f_36096_;
        if (!(container instanceof AssemblyHaloContainer) || !(inv instanceof CraftingContainer)) {
            return;
        }
        CraftingContainer cc = (CraftingContainer)inv;
        player.m_9236_().m_7465_().m_44015_(RecipeType.f_44107_, (Container)cc, player.m_9236_()).ifPresent(recipe -> {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || !(stack.m_41720_() instanceof AssemblyHaloItem)) continue;
                AssemblyHaloItem.rememberLastRecipe(recipe.m_6423_(), stack);
            }
        });
    }

    private static void rememberLastRecipe(ResourceLocation recipeId, ItemStack halo) {
        ItemNBTHelper.setString(halo, TAG_LAST_CRAFTING, recipeId.toString());
    }

    @Nullable
    private static Recipe<CraftingContainer> getLastRecipe(Level world, ItemStack halo) {
        String savedId = ItemNBTHelper.getString(halo, TAG_LAST_CRAFTING, "");
        ResourceLocation id = savedId.isEmpty() ? null : ResourceLocation.m_135820_((String)savedId);
        return BotaniaRecipeTypes.getRecipes(world, RecipeType.f_44107_).get(id);
    }

    private static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
    }

    private static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
    }

    private static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0.0f);
    }

    private static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
    }

    public ResourceLocation getGlowResource(ItemStack stack) {
        return glowTexture;
    }

    public static class RecipePlacer
    extends ServerPlaceRecipe<CraftingContainer> {
        public RecipePlacer(RecipeBookMenu<CraftingContainer> container) {
            super(container);
        }

        public boolean place(ServerPlayer player, @Nullable Recipe<CraftingContainer> recipe) {
            if (recipe != null) {
                boolean ret;
                this.f_135427_ = player.m_150109_();
                this.f_135426_.m_36453_();
                player.m_150109_().m_36010_(this.f_135426_);
                this.f_135428_.m_5816_(this.f_135426_);
                if (this.f_135426_.m_36475_(recipe, null)) {
                    this.m_6024_(recipe, false);
                    ret = true;
                } else {
                    this.m_179844_(true);
                    ret = false;
                }
                player.m_150109_().m_6596_();
                return ret;
            }
            return false;
        }

        public void m_179844_(boolean unknown) {
            super.m_179844_(unknown);
        }
    }

    public static class Rendering {
        public static void onRenderWorldLast(Camera camera, float partialTicks, PoseStack ms, RenderBuffers buffers) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack stack = PlayerHelper.getFirstHeldItemClass((LivingEntity)player, AssemblyHaloItem.class);
            if (stack.m_41619_()) {
                return;
            }
            MultiBufferSource.BufferSource bufferSource = buffers.m_110104_();
            double renderPosX = camera.m_90583_().m_7096_();
            double renderPosY = camera.m_90583_().m_7098_();
            double renderPosZ = camera.m_90583_().m_7094_();
            ms.m_85836_();
            float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
            double posX = player.f_19854_ + (player.m_20185_() - player.f_19854_) * (double)partialTicks;
            double posY = player.f_19855_ + (player.m_20186_() - player.f_19855_) * (double)partialTicks + (double)player.m_20192_();
            double posZ = player.f_19856_ + (player.m_20189_() - player.f_19856_) * (double)partialTicks;
            ms.m_85837_(posX - renderPosX, posY - renderPosY, posZ - renderPosZ);
            float base = AssemblyHaloItem.getRotationBase(stack);
            int angles = 360;
            int segAngles = angles / 12;
            float shift = base - (float)segAngles / 2.0f;
            float u = 1.0f;
            float v = 0.25f;
            float s = 3.0f;
            float m = 0.8f;
            float y = v * s * 2.0f;
            float y0 = 0.0f;
            int segmentLookedAt = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            AssemblyHaloItem item = (AssemblyHaloItem)stack.m_41720_();
            RenderType layer = RenderHelper.getHaloLayer(item.getGlowResource(stack));
            for (int seg = 0; seg < 12; ++seg) {
                ItemStack slotStack;
                boolean inside = false;
                float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
                ms.m_85836_();
                ms.m_85845_(Vector3f.f_122225_.m_122240_(rotationAngle));
                ms.m_85837_((double)(s * m), -0.75, 0.0);
                if (segmentLookedAt == seg) {
                    inside = true;
                }
                if (!(slotStack = AssemblyHaloItem.getDisplayItem(player.m_9236_(), stack, seg)).m_41619_()) {
                    float scale = seg == 0 ? 0.9f : 0.8f;
                    ms.m_85841_(scale, scale, scale);
                    ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    ms.m_85837_(seg == 0 ? 0.5 : 0.0, seg == 0 ? (double)-0.1f : (double)0.6f, 0.0);
                    ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                    Minecraft.m_91087_().m_91291_().m_174269_(slotStack, ItemTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.f_118083_, ms, (MultiBufferSource)bufferSource, player.m_19879_());
                }
                ms.m_85849_();
                ms.m_85836_();
                ms.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                float a = alpha;
                if (inside) {
                    a += 0.3f;
                    y0 = -y;
                }
                if (seg % 2 == 0) {
                    b = 0.6f;
                    g = 0.6f;
                    r = 0.6f;
                }
                VertexConsumer buffer = bufferSource.m_6299_(layer);
                for (int i = 0; i < segAngles; ++i) {
                    Matrix4f mat = ms.m_85850_().m_85861_();
                    float ang = (float)(i + seg * segAngles) + shift;
                    float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * s;
                    float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * s;
                    buffer.m_85982_(mat, xp * m, y, zp * m).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
                    buffer.m_85982_(mat, xp, y0, zp).m_85950_(r, g, b, a).m_7421_(u, 0.0f).m_5752_();
                    xp = (float)Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                    zp = (float)Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                    buffer.m_85982_(mat, xp, y0, zp).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_5752_();
                    buffer.m_85982_(mat, xp * m, y, zp * m).m_85950_(r, g, b, a).m_7421_(0.0f, v).m_5752_();
                }
                y0 = 0.0f;
                ms.m_85849_();
            }
            ms.m_85849_();
            bufferSource.m_109911_();
        }

        public static void renderHUD(PoseStack ms, Player player, ItemStack stack) {
            Minecraft mc = Minecraft.m_91087_();
            int slot = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            if (slot == 0) {
                String name = craftingTable.m_41786_().getString();
                int l = mc.f_91062_.m_92895_(name);
                int x = mc.m_91268_().m_85445_() / 2 - l / 2;
                int y = mc.m_91268_().m_85446_() / 2 - 65;
                GuiComponent.m_93172_((PoseStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x22000000);
                GuiComponent.m_93172_((PoseStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x22000000);
                mc.m_91291_().m_115203_(craftingTable, mc.m_91268_().m_85445_() / 2 - 8, mc.m_91268_().m_85446_() / 2 - 52);
                mc.f_91062_.m_92750_(ms, name, (float)x, (float)y, 0xFFFFFF);
            } else {
                MutableComponent label;
                Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(player.m_9236_(), stack, slot);
                boolean setRecipe = false;
                if (recipe == null) {
                    label = Component.m_237115_((String)"botaniamisc.unsetRecipe");
                    recipe = AssemblyHaloItem.getLastRecipe(player.m_9236_(), stack);
                } else {
                    label = recipe.m_8043_().m_41786_();
                    setRecipe = true;
                }
                Rendering.renderRecipe(ms, (Component)label, recipe, player, setRecipe);
            }
        }

        private static void renderRecipe(PoseStack ms, Component label, @Nullable Recipe<CraftingContainer> recipe, Player player, boolean isSavedRecipe) {
            Minecraft mc = Minecraft.m_91087_();
            if (recipe != null && !recipe.m_8043_().m_41619_()) {
                int n;
                int x = mc.m_91268_().m_85445_() / 2 - 45;
                int y = mc.m_91268_().m_85446_() / 2 - 90;
                GuiComponent.m_93172_((PoseStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + 90 + 6), (int)(y + 60), (int)0x22000000);
                GuiComponent.m_93172_((PoseStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + 90 + 4), (int)(y + 58), (int)0x22000000);
                GuiComponent.m_93172_((PoseStack)ms, (int)(x + 66), (int)(y + 14), (int)(x + 92), (int)(y + 40), (int)0x22000000);
                GuiComponent.m_93172_((PoseStack)ms, (int)(x - 2), (int)(y - 2), (int)(x + 56), (int)(y + 56), (int)0x22000000);
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)recipe;
                    n = shaped.m_44220_();
                } else {
                    n = 3;
                }
                int wrap = n;
                for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                    Ingredient ingr = (Ingredient)recipe.m_7527_().get(i);
                    if (ingr == Ingredient.f_43901_) continue;
                    ItemStack stack = ingr.m_43908_()[ClientTickHandler.ticksInGame / 20 % ingr.m_43908_().length];
                    int xpos = x + i % wrap * 18;
                    int ypos = y + i / wrap * 18;
                    GuiComponent.m_93172_((PoseStack)ms, (int)xpos, (int)ypos, (int)(xpos + 16), (int)(ypos + 16), (int)0x22000000);
                    mc.m_91291_().m_115203_(stack, xpos, ypos);
                }
                mc.m_91291_().m_115203_(recipe.m_8043_(), x + 72, y + 18);
                mc.m_91291_().m_115169_(mc.f_91062_, recipe.m_8043_(), x + 72, y + 18);
            }
            int yoff = 110;
            if (isSavedRecipe && recipe != null && !AssemblyHaloItem.canCraftHeuristic(player, recipe)) {
                String warning = ChatFormatting.RED + I18n.m_118938_((String)"botaniamisc.cantCraft", (Object[])new Object[0]);
                mc.f_91062_.m_92750_(ms, warning, (float)mc.m_91268_().m_85445_() / 2.0f - (float)mc.f_91062_.m_92895_(warning) / 2.0f, (float)mc.m_91268_().m_85446_() / 2.0f - (float)yoff, 0xFFFFFF);
                yoff += 12;
            }
            mc.f_91062_.m_92763_(ms, label, (float)mc.m_91268_().m_85445_() / 2.0f - (float)mc.f_91062_.m_92895_(label.getString()) / 2.0f, (float)mc.m_91268_().m_85446_() / 2.0f - (float)yoff, 0xFFFFFF);
        }
    }
}

