/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.BotaniaConfig;

public class AgricarnationBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final Set<Material> MATERIALS = ImmutableSet.of((Object)Material.f_76300_, (Object)Material.f_76277_, (Object)Material.f_76315_, (Object)Material.f_76274_, (Object)Material.f_76285_, (Object)Material.f_76301_, (Object[])new Material[]{Material.f_76271_, Material.f_76270_});
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;

    protected AgricarnationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AgricarnationBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.AGRICARNATION, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.getEffectivePos().m_123341_() + this.m_58904_().f_46441_.m_188503_(range * 2 + 1) - range;
            int z = this.getEffectivePos().m_123343_() + this.m_58904_().f_46441_.m_188503_(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                int y = this.getEffectivePos().m_123342_() + i;
                BlockPos pos = new BlockPos(x, y, z);
                if (this.m_58904_().m_46859_(pos) || !this.isPlant(pos) || this.getMana() <= 5) continue;
                BlockState state = this.m_58904_().m_8055_(pos);
                this.addMana(-5);
                state.m_222972_((ServerLevel)this.f_58857_, pos, this.f_58857_.f_46441_);
                if (BotaniaConfig.common().blockBreakParticles()) {
                    this.m_58904_().m_46796_(2005, pos, 6 + this.m_58904_().f_46441_.m_188503_(4));
                }
                this.m_58904_().m_6263_(null, (double)x, (double)y, (double)z, BotaniaSounds.agricarnation, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(BlockPos pos) {
        BonemealableBlock mealable;
        BlockState state = this.m_58904_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof SpreadingSnowyDirtBlock) {
            return false;
        }
        if (!(!(block instanceof BushBlock) || block instanceof CropBlock || block instanceof StemBlock || block instanceof SaplingBlock || block instanceof SweetBerryBushBlock)) {
            return false;
        }
        return MATERIALS.contains(state.m_60767_()) && block instanceof BonemealableBlock && (mealable = (BonemealableBlock)block).m_7370_((BlockGetter)this.m_58904_(), pos, state, this.m_58904_().f_46443_);
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends AgricarnationBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.AGRICARNATION_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }
    }
}

