/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class ManaBarTooltipComponent
implements ClientTooltipComponent {
    private final float percentageFull;
    private final int pickLevel;
    private int mouseX;
    private int mouseY;
    private int totalWidth;

    public ManaBarTooltipComponent(ManaBarTooltip component) {
        this.percentageFull = component.getPercentageFull();
        this.pickLevel = component.getPickLevel();
    }

    @Nullable
    public static ClientTooltipComponent tryConvert(TooltipComponent component) {
        if (component instanceof ManaBarTooltip) {
            ManaBarTooltip t = (ManaBarTooltip)component;
            return new ManaBarTooltipComponent(t);
        }
        return null;
    }

    public int m_142103_() {
        return 0;
    }

    public int m_142069_(Font font) {
        return 0;
    }

    public void setContext(int mouseX, int mouseY, int totalWidth) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.totalWidth = totalWidth;
    }

    public void m_142440_(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource buffers) {
        int level = this.pickLevel;
        if (level < 0) {
            return;
        }
        boolean ss = level >= TerraShattererItem.LEVELS.length - 1;
        String rank = I18n.m_118938_((String)("botania.rank" + this.pickLevel), (Object[])new Object[0]).replaceAll("&", "\u00a7");
        font.m_92811_(rank, (float)this.mouseX, (float)(this.mouseY - 16), 0xFFFFFF, true, matrix, (MultiBufferSource)buffers, false, 0, 0xF000F0);
        if (!ss) {
            rank = I18n.m_118938_((String)("botania.rank" + (level + 1)), (Object[])new Object[0]).replaceAll("&", "\u00a7");
            font.m_92811_(rank, (float)(this.mouseX + this.totalWidth - font.m_92895_(rank)), (float)(this.mouseY - 16), 0xFFFFFF, true, matrix, (MultiBufferSource)buffers, false, 0, 0xF000F0);
        }
    }

    public void m_183452_(Font font, int x, int y, PoseStack ps, ItemRenderer renderer, int z) {
        int height = 3;
        int offsetFromBox = 4;
        ps.m_85836_();
        ps.m_85837_(0.0, 0.0, (double)z);
        if (this.pickLevel >= 0) {
            boolean ss = this.pickLevel >= TerraShattererItem.LEVELS.length - 1;
            int rainbowWidth = Math.min(this.totalWidth - (ss ? 0 : 1), (int)((float)this.totalWidth * this.percentageFull));
            float huePer = this.totalWidth == 0 ? 0.0f : 1.0f / (float)this.totalWidth;
            float hueOff = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01f;
            GuiComponent.m_93172_((PoseStack)ps, (int)(this.mouseX - 1), (int)(this.mouseY - height - offsetFromBox - 1), (int)(this.mouseX + this.totalWidth + 1), (int)(this.mouseY - offsetFromBox), (int)-16777216);
            for (int i = 0; i < rainbowWidth; ++i) {
                GuiComponent.m_93172_((PoseStack)ps, (int)(this.mouseX + i), (int)(this.mouseY - height - offsetFromBox), (int)(this.mouseX + i + 1), (int)(this.mouseY - offsetFromBox), (int)(0xFF000000 | Mth.m_14169_((float)((hueOff + huePer * (float)i) % 1.0f), (float)1.0f, (float)1.0f)));
            }
            GuiComponent.m_93172_((PoseStack)ps, (int)(this.mouseX + rainbowWidth), (int)(this.mouseY - height - offsetFromBox), (int)(this.mouseX + this.totalWidth), (int)(this.mouseY - offsetFromBox), (int)-11184811);
        } else {
            int manaBarWidth = (int)Math.ceil((float)this.totalWidth * this.percentageFull);
            GuiComponent.m_93172_((PoseStack)ps, (int)(this.mouseX - 1), (int)(this.mouseY - height - offsetFromBox - 1), (int)(this.mouseX + this.totalWidth + 1), (int)(this.mouseY - offsetFromBox), (int)-16777216);
            GuiComponent.m_93172_((PoseStack)ps, (int)this.mouseX, (int)(this.mouseY - height - offsetFromBox), (int)(this.mouseX + manaBarWidth), (int)(this.mouseY - offsetFromBox), (int)(0xFF000000 | Mth.m_14169_((float)0.528f, (float)(((float)Math.sin((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1.0f) * 0.3f + 0.4f), (float)1.0f)));
            GuiComponent.m_93172_((PoseStack)ps, (int)(this.mouseX + manaBarWidth), (int)(this.mouseY - height - offsetFromBox), (int)(this.mouseX + this.totalWidth), (int)(this.mouseY - offsetFromBox), (int)-11184811);
        }
        ps.m_85849_();
        this.mouseY = 0;
        this.mouseX = 0;
        this.totalWidth = 50;
    }
}

