/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.util.BlockApiCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaStorageImportStrategy
implements StackImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManaStorageImportStrategy.class);
    private final BlockApiCache<ManaReceiver> apiCache;
    private final Direction fromSide;

    public ManaStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create((Capability)BotaniaForgeCapabilities.MANA_RECEIVER, (ServerLevel)level, (BlockPos)fromPos);
        this.fromSide = fromSide;
    }

    public boolean transfer(StackTransferContext context) {
        long inserted;
        if (!context.isKeyTypeEnabled(ManaKeyType.TYPE)) {
            return false;
        }
        ManaReceiver receiver = (ManaReceiver)this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)ManaKeyType.TYPE.getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        int amount = (int)Math.min(remainingTransferAmount, (long)receiver.getCurrentMana());
        if (amount > 0) {
            receiver.receiveMana(-amount);
        }
        if ((inserted = inv.getInventory().insert(ManaKey.KEY, (long)amount, Actionable.MODULATE, context.getActionSource())) < (long)amount) {
            long leftover = (long)amount - inserted;
            int backfill = (int)Math.min(leftover, (long)(ManaHelper.getCapacity(receiver) - receiver.getCurrentMana()));
            if (backfill > 0) {
                receiver.receiveMana(backfill);
            }
            if (leftover > (long)backfill) {
                LOGGER.error("Storage import issue, voided {} mana", (Object)(leftover - (long)backfill));
            }
        }
        long opsUsed = Math.max(1L, inserted / (long)ManaKeyType.TYPE.getAmountPerOperation());
        context.reduceOperationsRemaining(opsUsed);
        return amount > 0;
    }
}

