/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import appeng.util.BlockApiCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaExternalStorageStrategy
implements ExternalStorageStrategy {
    private final BlockApiCache<ManaReceiver> apiCache;
    private final Direction fromSide;

    public ManaExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create((Capability)BotaniaForgeCapabilities.MANA_RECEIVER, (ServerLevel)level, (BlockPos)fromPos);
        this.fromSide = fromSide;
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable injectOrExtractCallback) {
        ManaReceiver receiver = (ManaReceiver)this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return null;
        }
        return new ManaStorageAdapter(receiver, injectOrExtractCallback);
    }

    private record ManaStorageAdapter(ManaReceiver receiver, Runnable injectOrExtractCallback) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ManaKey)) {
                return 0L;
            }
            int inserted = (int)Math.min(amount, (long)(ManaHelper.getCapacity(this.receiver) - this.receiver.getCurrentMana()));
            if (inserted > 0 && mode == Actionable.MODULATE) {
                this.receiver.receiveMana(inserted);
                this.injectOrExtractCallback.run();
            }
            return inserted;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ManaKey)) {
                return 0L;
            }
            int extracted = (int)Math.min(amount, (long)this.receiver.getCurrentMana());
            if (extracted > 0 && mode == Actionable.MODULATE) {
                this.receiver.receiveMana(-extracted);
                this.injectOrExtractCallback.run();
            }
            return extracted;
        }

        public void getAvailableStacks(KeyCounter out) {
            int currentMana = this.receiver.getCurrentMana();
            if (currentMana != 0) {
                out.add(ManaKey.KEY, (long)currentMana);
            }
        }

        public Component getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{ManaKeyType.TYPE.getDescription()});
        }
    }
}

