/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village.wanderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.common.BasicItemListing;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.trades.AffixTrade;
import shadows.apotheosis.village.VillageModule;
import shadows.apotheosis.village.wanderer.BasicJsonTrade;
import shadows.apotheosis.village.wanderer.JsonTrade;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class WandererTradeManager
extends PlaceboJsonReloadListener<JsonTrade> {
    public static final WandererTradeManager INSTANCE = new WandererTradeManager();
    protected final Map<ResourceLocation, BasicItemListing> registry = new HashMap<ResourceLocation, BasicItemListing>();
    protected final List<VillagerTrades.ItemListing> normTrades = new ArrayList<VillagerTrades.ItemListing>();
    protected final List<VillagerTrades.ItemListing> rareTrades = new ArrayList<VillagerTrades.ItemListing>();

    public WandererTradeManager() {
        super(VillageModule.LOGGER, "wanderer_trades", false, true);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(Apotheosis.loc("basic_trade"), BasicJsonTrade.SERIALIZER);
        this.registerSerializer(Apotheosis.loc("affix"), AffixTrade.SERIALIZER);
    }

    protected <T extends JsonTrade> void register(ResourceLocation key, T trade) {
        super.register(key, trade);
    }

    protected void onReload() {
        super.onReload();
        this.getValues().forEach(trade -> {
            if (trade.isRare()) {
                this.rareTrades.add((VillagerTrades.ItemListing)trade);
            } else {
                this.normTrades.add((VillagerTrades.ItemListing)trade);
            }
        });
    }

    public List<VillagerTrades.ItemListing> getNormalTrades() {
        return this.normTrades;
    }

    public List<VillagerTrades.ItemListing> getRareTrades() {
        return this.rareTrades;
    }
}

