/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.compat.AdventureJEIPlugin;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.util.RarityIngredient;

public class SalvagingCategory
implements IRecipeCategory<SalvagingRecipe> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/salvage_jei.png");
    private final Component title = Component.m_237115_((String)"title.apotheosis.salvaging");
    private final IDrawable background;
    private final IDrawable icon;
    private final Map<LootRarity, List<ItemStack>> displayItems = new HashMap<LootRarity, List<ItemStack>>();

    public SalvagingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURES, 0, 0, 98, 74).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Apoth.Blocks.SALVAGING_TABLE.get()));
    }

    public RecipeType<SalvagingRecipe> getRecipeType() {
        return AdventureJEIPlugin.SALVAGING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(SalvagingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        List<SalvagingRecipe.OutputData> outputs = recipe.getOutputs();
        Font font = Minecraft.m_91087_().f_91062_;
        int idx = 0;
        for (SalvagingRecipe.OutputData d : outputs) {
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, 200.0);
            String text = String.format("%d-%d", d.getMin(), d.getMax());
            float x = (float)(59 + 18 * (idx % 2)) + (16.0f - (float)font.m_92895_(text) * 0.5f);
            float y = 23.0f + (float)(18 * (idx / 2));
            float scale = 0.5f;
            stack.m_85841_(scale, scale, 1.0f);
            font.m_92750_(stack, text, x / scale, y / scale, 0xFFFFFF);
            ++idx;
            stack.m_85849_();
        }
    }

    private List<ItemStack> createFakeDisplayItems(LootRarity rarity) {
        LegacyRandomSource src = new LegacyRandomSource(0L);
        List<ItemStack> out = Arrays.asList(Items.f_42388_, Items.f_42390_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_).stream().map(ItemStack::new).toList();
        out.forEach(arg_0 -> SalvagingCategory.lambda$createFakeDisplayItems$0(rarity, (RandomSource)src, arg_0));
        return out;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SalvagingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> input = Arrays.asList(recipe.getInput().m_43908_());
        Ingredient ingredient = recipe.getInput();
        if (ingredient instanceof RarityIngredient) {
            RarityIngredient ri = (RarityIngredient)ingredient;
            input = this.displayItems.computeIfAbsent(ri.getRarity(), this::createFakeDisplayItems);
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 5, 29).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)input);
        } else {
            if (input.size() == 1 && input.get(0).m_41720_() == Apoth.Items.GEM.get()) {
                LootRarity rarity = AffixHelper.getRarity(((ItemStack)input.get(0)).m_41783_());
                LegacyRandomSource rand = new LegacyRandomSource(0L);
                input = GemManager.INSTANCE.getValues().stream().filter(gem -> rarity == null || gem.clamp(rarity) == rarity).map(arg_0 -> SalvagingCategory.lambda$setRecipe$2((RandomSource)rand, rarity, arg_0)).toList();
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 5, 29).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)input);
        }
        List<SalvagingRecipe.OutputData> outputs = recipe.getOutputs();
        int idx = 0;
        for (SalvagingRecipe.OutputData d : outputs) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 59 + 18 * (idx % 2), 11 + 18 * (idx / 2)).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)d.getStack());
            ++idx;
        }
    }

    private static /* synthetic */ ItemStack lambda$setRecipe$2(RandomSource rand, LootRarity rarity, Gem gem) {
        return GemManager.createGemStack(gem, rand, rarity, 0.0f);
    }

    private static /* synthetic */ void lambda$createFakeDisplayItems$0(LootRarity rarity, RandomSource src, ItemStack stack) {
        LootController.createLootItem(stack, rarity, src);
        AffixHelper.setName(stack, (Component)Component.m_237110_((String)"text.apotheosis.any_x_item", (Object[])new Object[]{rarity.toComponent(), ""}).m_130948_(Style.f_131099_.m_131148_(rarity.color())));
    }
}

