/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Configuration {
    public static final String CATEGORY_GENERAL = "general";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue BalancedRecipe;
    public static ForgeConfigSpec.IntValue XPCost;
    public static ForgeConfigSpec.IntValue TicksPerDrain;
    public static ForgeConfigSpec.IntValue EnergeticFEPerTick;
    public static ForgeConfigSpec.IntValue EnergeticFECapacity;
    public static ForgeConfigSpec.IntValue LeadstoneFEPerTick;
    public static ForgeConfigSpec.IntValue LeadstoneCapacity;
    public static ForgeConfigSpec.IntValue HardenedFEPerTick;
    public static ForgeConfigSpec.IntValue HardenedCapacity;
    public static ForgeConfigSpec.IntValue ReinforcedFEPerTick;
    public static ForgeConfigSpec.IntValue ReinforcedCapacity;
    public static ForgeConfigSpec.IntValue ResonantFEPerTick;
    public static ForgeConfigSpec.IntValue ResonantCapacity;
    public static ForgeConfigSpec.IntValue XPWarningLevel;
    public static ForgeConfigSpec.IntValue EnergyWarningPercentage;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public ForgeConfigSpec getSpec() {
        return SERVER_CONFIG;
    }

    static {
        COMMON_BUILDER.comment("General Angel Ring 2 configuration options.").push(CATEGORY_GENERAL);
        XPCost = COMMON_BUILDER.comment("Defines how much XP will be drained from player when flying by wearing Classic Angel Ring. Put 0 if you need to disable XP requirement for flight.").defineInRange("XPCost", 3, 0, Integer.MAX_VALUE);
        TicksPerDrain = COMMON_BUILDER.comment("Defines how much ticks is required to pass between each XP drain event of Classic Angel Ring").defineInRange("TicksPerDrain", 50, 1, Integer.MAX_VALUE);
        EnergeticFEPerTick = COMMON_BUILDER.comment("Defines how much FE the Energetic Angel Ring will drain every tick while flying.").defineInRange("EnergeticFEPerTick", 150, 1, Integer.MAX_VALUE);
        EnergeticFECapacity = COMMON_BUILDER.comment("Defines how much FE the Energetic Angel Ring can store.").defineInRange("EnergeticFECapacity", 3000000, 1, Integer.MAX_VALUE);
        LeadstoneFEPerTick = COMMON_BUILDER.comment("Defines how much FE the Leadstone Angel Ring will drain every tick while flying.").defineInRange("LeadstoneFEPerTick", 250, 1, Integer.MAX_VALUE);
        LeadstoneCapacity = COMMON_BUILDER.comment("Defines how much FE the Leadstone Angel Ring can store.").defineInRange("LeadstoneFECapacity", 2500000, 1, Integer.MAX_VALUE);
        HardenedFEPerTick = COMMON_BUILDER.comment("Defines how much FE the Hardened Angel Ring will drain every tick while flying.").defineInRange("HardenedFEPerTick", 200, 1, Integer.MAX_VALUE);
        HardenedCapacity = COMMON_BUILDER.comment("Defines how much FE the Hardened Angel Ring can store.").defineInRange("HardenedFECapacity", 5000000, 1, Integer.MAX_VALUE);
        ReinforcedFEPerTick = COMMON_BUILDER.comment("Defines how much FE the Reinforced Angel Ring will drain every tick while flying.").defineInRange("ReinforcedFEPerTick", 100, 1, Integer.MAX_VALUE);
        ReinforcedCapacity = COMMON_BUILDER.comment("Defines how much FE the Reinforced Angel Ring can store.").defineInRange("ReinforcedFECapacity", 8000000, 1, Integer.MAX_VALUE);
        ResonantFEPerTick = COMMON_BUILDER.comment("Defines how much FE the Resonant Angel Ring will drain every tick while flying.").defineInRange("ResonantFEPerTick", 50, 1, Integer.MAX_VALUE);
        ResonantCapacity = COMMON_BUILDER.comment("Defines how much FE the Resonant Angel Ring can store.").defineInRange("ResonantFECapacity", 16000000, 1, Integer.MAX_VALUE);
        XPWarningLevel = COMMON_BUILDER.comment("Defines at what XP Level to start displaying a warning of low XP for the Classic Angel Ring. Set to -1 to disable.").defineInRange("XPWarningLevel", 3, -1, Integer.MAX_VALUE);
        EnergyWarningPercentage = COMMON_BUILDER.comment("Defines at what percentage to start displaying a warning of low power for Energy Angel Rings. Set to -1 to disable.").defineInRange("EnergyWarningPercentage", 5, -1, 100);
        COMMON_BUILDER.pop();
        SERVER_CONFIG = COMMON_BUILDER.build();
    }
}

