/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.computer.ComputerSide;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoordUtil {
    public static boolean isInRange(@Nullable BlockPos pos, @Nullable Level world, @Nullable Player player, int range) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        range = Math.min(Math.abs(range), (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        return CoordUtil.isPlayerInBlockRange(pos, world, player, range);
    }

    private static boolean isPlayerInBlockRange(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, double range) {
        if (player.m_9236_() != world) {
            return false;
        }
        double x = player.m_20185_();
        double y = player.m_20186_();
        double ey = player.m_20188_();
        double z = player.m_20189_();
        if (ey > y) {
            double tmp = ey;
            ey = y;
            y = tmp;
        }
        double bx = (double)pos.m_123341_() + 0.5;
        double by = (double)pos.m_123342_() + 0.5;
        double bz = (double)pos.m_123343_() + 0.5;
        return Math.abs(x - bx) <= range && Math.abs(z - bz) <= range && (y <= by && by <= ey || Math.min(Math.abs(y - by), Math.abs(ey - by)) <= range);
    }

    public static boolean isInRange(@Nullable BlockPos pos, @Nullable Level world, @Nullable Player player, int x, int y, int z) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        x = Math.min(Math.abs(x), (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        y = Math.min(Math.abs(y), (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        z = Math.min(Math.abs(z), (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        return CoordUtil.isPlayerInBlockRangeXYZ(pos, world, player, x, y, z);
    }

    private static boolean isPlayerInBlockRangeXYZ(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, double dx, double dy, double dz) {
        if (player.m_9236_() != world) {
            return false;
        }
        double x = player.m_20185_();
        double y = player.m_20186_();
        double ey = player.m_20188_();
        double z = player.m_20189_();
        if (ey > y) {
            double tmp = ey;
            ey = y;
            y = tmp;
        }
        double bx = (double)pos.m_123341_() + 0.5;
        double by = (double)pos.m_123342_() + 0.5;
        double bz = (double)pos.m_123343_() + 0.5;
        return Math.abs(x - bx) <= dx && Math.abs(z - bz) <= dz && (y <= by && by <= ey || Math.min(Math.abs(y - by), Math.abs(ey - by)) <= dy);
    }

    public static boolean isInRange(@Nullable BlockPos blockPos, @Nullable Player player, @Nullable Level world, @NotNull BlockPos firstPos, @NotNull BlockPos secondPos) {
        double j;
        if (blockPos == null || world == null || player == null) {
            return false;
        }
        double i = Math.abs(player.m_20185_() - (double)blockPos.m_123341_());
        if (i + (j = Math.abs(player.m_20189_() - (double)blockPos.m_123343_())) > (double)((Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get()).intValue()) {
            return false;
        }
        return world.m_45955_(TargetingConditions.m_148353_(), null, new AABB(firstPos, secondPos)).contains(player);
    }

    public static Direction getDirection(FrontAndTop orientation, String computerSide) throws LuaException {
        if (computerSide == null) {
            throw new LuaException("null is not a valid side");
        }
        Direction dir = Direction.m_122402_((String)(computerSide = computerSide.toLowerCase(Locale.ROOT)));
        if (dir != null) {
            return dir;
        }
        Direction top = orientation.m_122629_();
        Direction front = orientation.m_122625_();
        ComputerSide side = ComputerSide.valueOfInsensitive((String)computerSide);
        if (side == null) {
            throw new LuaException(computerSide + " is not a valid side");
        }
        if (front.m_122434_() == Direction.Axis.Y) {
            switch (side) {
                case FRONT: {
                    return front;
                }
                case BACK: {
                    return front.m_122424_();
                }
                case TOP: {
                    return top;
                }
                case BOTTOM: {
                    return top.m_122424_();
                }
                case RIGHT: {
                    return top.m_122427_();
                }
                case LEFT: {
                    return top.m_122428_();
                }
            }
        } else {
            switch (side) {
                case FRONT: {
                    return front;
                }
                case BACK: {
                    return front.m_122424_();
                }
                case TOP: {
                    return Direction.UP;
                }
                case BOTTOM: {
                    return Direction.DOWN;
                }
                case RIGHT: {
                    return front.m_122428_();
                }
                case LEFT: {
                    return front.m_122427_();
                }
            }
        }
        throw new LuaException(computerSide + " is not a expected side");
    }
}

