/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryInitialMessage;
import com.yogpc.qp.machines.advquarry.ItemAdvQuarry;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleLootFunction;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class BlockAdvQuarry
extends QPBlock
implements EntityBlock {
    public static final String NAME = "adv_quarry";

    public BlockAdvQuarry() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME, ItemAdvQuarry::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.ADV_QUARRY_TYPE.m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING, BlockStateProperties.f_61372_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43723_() == null ? Direction.NORTH : ctx.m_43723_().m_6350_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, world, pos, block, fromPos, notify);
        if (!world.f_46443_) {
            world.m_141902_(pos, Holder.ADV_QUARRY_TYPE).ifPresent(TileAdvQuarry::updateModule);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileAdvQuarry) {
                TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
                quarry.setAction(AdvQuarryAction.Waiting.WAITING);
                player.m_5661_((Component)Component.m_237115_((String)"quarryplus.chat.quarry.restart"), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileAdvQuarry) {
                TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
                if (stack.m_41720_() instanceof QuarryModuleProvider.Item) {
                    quarry.openModuleGui((ServerPlayer)player);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)quarry, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (state.m_60734_() != oldState.m_60734_() && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileAdvQuarry) {
            Area defaultArea;
            TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
            quarry.initialSetting();
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            if (!quarry.setArea(BlockAdvQuarry.findArea(level, pos, facing.m_122424_(), quarry.getStorage()::addItem)) && !quarry.setArea(defaultArea = BlockAdvQuarry.createDefaultArea(pos, facing.m_122424_(), (Integer)QuarryPlus.config.common.chunkDestroyerLimit.get()))) {
                AdvQuarry.LOGGER.warn(AdvQuarry.BLOCK, "The default area is invalid. Area={}, Limit={}, Pos={}", (Object)defaultArea, QuarryPlus.config.common.chunkDestroyerLimit.get(), (Object)pos);
            }
            boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, quarry.enabled);
            quarry.setChunkPreLoaded(preForced);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
            List<EnchantmentLevel> enchantment = EnchantmentLevel.fromItem(stack);
            enchantment.sort(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR);
            quarry.setEnchantments(enchantment);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!(entity instanceof FakePlayer)) {
                    quarry.workConfig = quarry.workConfig.noAutoStartConfig();
                    PacketHandler.sendToClientPlayer(new AdvQuarryInitialMessage.Ask(pos, (ResourceKey<Level>)level.m_46472_()), player);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : BlockAdvQuarry.checkType(type, Holder.ADV_QUARRY_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), EnergyModuleItem.energyModuleTicker(), TileAdvQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
            EnchantedLootFunction.process(stack, quarry);
            ModuleLootFunction.process(stack, quarry);
        }
        return stack;
    }

    static Area findArea(Level world, BlockPos pos, Direction quarryBehind, Consumer<ItemStack> itemCollector) {
        return Stream.of(quarryBehind, quarryBehind.m_122428_(), quarryBehind.m_122427_()).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).map(arg_0 -> ((Level)world).m_7702_(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(itemCollector))).map(a -> a.assureY(4)).findFirst().orElseGet(() -> BlockAdvQuarry.createDefaultArea(pos, quarryBehind, (Integer)QuarryPlus.config.common.chunkDestroyerLimit.get()));
    }

    @NotNull
    @VisibleForTesting
    static Area createDefaultArea(BlockPos pos, Direction quarryBehind, int limit) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (0 < limit && limit < 16) {
            if (pos.m_123341_() - limit / 2 < chunkPos.m_45604_()) {
                minX = chunkPos.m_45604_();
                maxX = minX + limit - 1;
            } else if (pos.m_123341_() + limit / 2 > chunkPos.m_45608_()) {
                maxX = chunkPos.m_45608_();
                minX = maxX - limit + 1;
            } else {
                minX = pos.m_123341_() - limit / 2;
                maxX = minX + limit - 1;
            }
            if (pos.m_123343_() - limit / 2 < chunkPos.m_45605_()) {
                minZ = chunkPos.m_45605_();
                maxZ = minZ + limit - 1;
            } else if (pos.m_123343_() + limit / 2 > chunkPos.m_45609_()) {
                maxZ = chunkPos.m_45609_();
                minZ = maxZ - limit + 1;
            } else {
                minZ = pos.m_123343_() - limit / 2;
                maxZ = minZ + limit - 1;
            }
        } else {
            minX = chunkPos.m_45604_();
            maxX = chunkPos.m_45608_();
            minZ = chunkPos.m_45605_();
            maxZ = chunkPos.m_45609_();
        }
        return new Area(minX - 1, pos.m_123342_(), minZ - 1, maxX + 1, pos.m_123342_() + 4, maxZ + 1, quarryBehind);
    }
}

