/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.mixin.minecraft;

import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.content.proof.SpaceOxygenProofUtils;
import earth.terrarium.ad_astra.common.registry.ModDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo callbackInfo) {
        LivingEntity living = (LivingEntity)this;
        if (!living.m_9236_().m_5776_()) {
            OxygenChargerUtils.distributeToItems(living);
        }
        ProofAbstractUtils.reduceProofDuration(living);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingEntity living;
        if (source == ModDamageSource.OXYGEN && SpaceOxygenProofUtils.INSTANCE.tryProvideProof(living = (LivingEntity)this)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }
}

