/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.GuiceObjectMapper;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapper;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapperFactory;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class GuiceObjectMapperFactory
implements ObjectMapperFactory {
    private final LoadingCache<Class<?>, ObjectMapper<?>> cache = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<Class<?>, ObjectMapper<?>>(){

        public ObjectMapper<?> load(Class<?> key) throws Exception {
            return new GuiceObjectMapper(GuiceObjectMapperFactory.this.injector, key);
        }
    });
    private final Injector injector;

    @Inject
    protected GuiceObjectMapperFactory(Injector baseInjector) {
        this.injector = baseInjector;
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull Class<T> type) throws ObjectMappingException {
        Preconditions.checkNotNull(type, (Object)"type");
        try {
            return (ObjectMapper)this.cache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "GuiceObjectMapperFactory{}";
    }
}

