/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.util;

public class Timer {
    private static double resolution = 1.0E9;
    private static long currentTime;
    private long startTime;
    private long lastTime;
    private boolean paused;

    public Timer() {
        this.reset();
        this.resume();
    }

    public float getTime() {
        if (!this.paused) {
            this.lastTime = currentTime - this.startTime;
        }
        return (float)((double)this.lastTime / resolution);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
    }

    public void reset() {
        this.set(0.0f);
    }

    public void resume() {
        this.paused = false;
        this.startTime = currentTime - this.lastTime;
    }

    public void set(float newTime) {
        long newTimeInTicks = (long)((double)newTime * resolution);
        this.startTime = currentTime - newTimeInTicks;
        this.lastTime = newTimeInTicks;
    }

    public static void tick() {
        currentTime = System.nanoTime();
    }

    public String toString() {
        return "Timer[Time=" + this.getTime() + ", Paused=" + this.paused + "]";
    }

    static {
        Timer.tick();
    }
}

