/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.gui;

import net.teamfruit.emojicord.compat.CompatBaseVertex;
import net.teamfruit.emojicord.compat.CompatVertex;
import net.teamfruit.emojicord.compat.OpenGL;
import net.teamfruit.emojicord.gui.Rectangle2d;

public interface IChatOverlay {
    default public boolean onDraw() {
        return false;
    }

    default public boolean onMouseClicked(int button) {
        return false;
    }

    default public boolean onMouseReleased(int button) {
        return false;
    }

    default public boolean onMouseScroll(double scrollDelta) {
        return false;
    }

    default public boolean onMouseInput(int mouseX, int mouseY) {
        return false;
    }

    default public boolean onCharTyped(char typed, int modifier) {
        return false;
    }

    default public boolean onKeyPressed(int keycode) {
        return false;
    }

    default public void onTick() {
    }

    public static void fill(int x1, int y1, int x2, int y2, int color) {
        if (x1 < x2) {
            int i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            int j = y1;
            y1 = y2;
            y2 = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        CompatBaseVertex t = CompatVertex.getTessellator();
        OpenGL.glEnable(3042);
        OpenGL.glDisable(3553);
        OpenGL.glBlendFuncSeparate(770, 771, 1, 0);
        OpenGL.glColor4f(f, f1, f2, f3);
        t.begin(7);
        t.pos(x1, y2, 0.0);
        t.pos(x2, y2, 0.0);
        t.pos(x2, y1, 0.0);
        t.pos(x1, y1, 0.0);
        t.draw();
        OpenGL.glEnable(3553);
        OpenGL.glDisable(3042);
    }

    public static void fill(Rectangle2d rect, int color) {
        IChatOverlay.fill(rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), color);
    }
}

