/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.teamfruit.emojicord.emoji.EmojiId;

public class StandardEmojiIdDictionary {
    public static StandardEmojiIdDictionary instance = new StandardEmojiIdDictionaryBuilder().build();
    public final ImmutableMap<String, EmojiId> nameDictionary;
    public final ImmutableMap<String, EmojiId> aliasDictionary;
    public final ImmutableMap<String, EmojiId> utfDictionary;
    public final Pattern shortAliasPattern;
    public final Pattern utfPattern;

    public StandardEmojiIdDictionary(ImmutableMap<String, EmojiId> nameDictionary, ImmutableMap<String, EmojiId> aliasDictionary, ImmutableMap<String, EmojiId> utfDictionary, Pattern shortAliasPattern, Pattern utfPattern) {
        this.nameDictionary = nameDictionary;
        this.aliasDictionary = aliasDictionary;
        this.utfDictionary = utfDictionary;
        this.shortAliasPattern = shortAliasPattern;
        this.utfPattern = utfPattern;
    }

    public static class StandardEmojiIdDictionaryBuilder {
        private static final Set<String> shortAliasBlacklist = Sets.newHashSet((Object[])new String[]{"+1", "-1"});
        private static final Set<String> utfBlacklist = Sets.newHashSet();
        private final Map<String, EmojiId> nameDictionary = Maps.newHashMap();
        private final Map<String, EmojiId> aliasDictionary = Maps.newHashMap();
        private final Map<String, EmojiId> utfDictionary = Maps.newHashMap();
        private static final Pattern shortAliasFilterNot = Pattern.compile(".+\\:skin-tone-\\d");
        private static final Pattern shortAliasFilter = Pattern.compile("^.*[^\\w].*$");
        private final Supplier<Map<String, EmojiId>> simpleName = Suppliers.memoize(() -> this.nameDictionary.entrySet().stream().filter(str -> !shortAliasFilterNot.matcher((CharSequence)str.getKey()).matches()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        private final Supplier<Set<String>> shortAlias = Suppliers.memoize(() -> this.aliasDictionary.keySet().stream().filter(str -> !shortAliasFilterNot.matcher((CharSequence)str).matches() && shortAliasFilter.matcher((CharSequence)str).matches() && !shortAliasBlacklist.contains(str)).collect(Collectors.toSet()));
        private final Supplier<Pattern> shortAliasPattern = Suppliers.memoize(() -> {
            ArrayList emoticons = Lists.newArrayList((Iterable)((Iterable)this.shortAlias.get()));
            for (int i = 0; i < emoticons.size(); ++i) {
                for (int j = i + 1; j < emoticons.size(); ++j) {
                    String o1 = (String)emoticons.get(i);
                    String o2 = (String)emoticons.get(j);
                    if (!o2.contains(o1)) continue;
                    String temp = o2;
                    emoticons.remove(j);
                    emoticons.add(i, temp);
                }
            }
            String emojiFilter = emoticons.stream().map(Pattern::quote).collect(Collectors.joining("|"));
            return Pattern.compile(String.format("(?<=^| )(?:%s)(?= |$)", emojiFilter));
        });
        private static final Pattern utfFilterNot = Pattern.compile(".+[\ud83c\udffb-\ud83c\udfff]$");
        private final Supplier<Set<String>> utf = Suppliers.memoize(() -> this.utfDictionary.keySet().stream().filter(str -> !utfFilterNot.matcher((CharSequence)str).matches() && !utfBlacklist.contains(str)).collect(Collectors.toSet()));
        private final Supplier<Pattern> utfPattern = Suppliers.memoize(() -> {
            String emojiFilter = ((Set)this.utf.get()).stream().map(Pattern::quote).collect(Collectors.joining("|"));
            String toneFilter = "[\ud83c\udffb-\ud83c\udfff]";
            return Pattern.compile(String.format("(?:%s)%s?", emojiFilter, "[\ud83c\udffb-\ud83c\udfff]"));
        });

        public StandardEmojiIdDictionaryBuilder putAllName(Map<String, EmojiId> dictionary) {
            this.nameDictionary.putAll(dictionary);
            return this;
        }

        public StandardEmojiIdDictionaryBuilder putAllAlias(Map<String, EmojiId> dictionary) {
            this.aliasDictionary.putAll(dictionary);
            return this;
        }

        public StandardEmojiIdDictionaryBuilder putAllUtf(Map<String, EmojiId> dictionary) {
            this.utfDictionary.putAll(dictionary);
            return this;
        }

        public StandardEmojiIdDictionaryBuilder putName(String key, EmojiId emojiId) {
            this.nameDictionary.put(key, emojiId);
            return this;
        }

        public StandardEmojiIdDictionaryBuilder putAlias(String key, EmojiId emojiId) {
            this.aliasDictionary.put(key, emojiId);
            return this;
        }

        public StandardEmojiIdDictionaryBuilder putUtf(String key, EmojiId emojiId) {
            this.utfDictionary.put(key, emojiId);
            return this;
        }

        public StandardEmojiIdDictionary build() {
            return new StandardEmojiIdDictionary((ImmutableMap<String, EmojiId>)ImmutableMap.copyOf((Map)((Map)this.simpleName.get())), (ImmutableMap<String, EmojiId>)ImmutableMap.copyOf(this.aliasDictionary), (ImmutableMap<String, EmojiId>)ImmutableMap.copyOf(this.utfDictionary), (Pattern)this.shortAliasPattern.get(), (Pattern)this.utfPattern.get());
        }
    }
}

