/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.RefName;
import net.teamfruit.emojicord.compat.CompatFMLDeobfuscatingRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodMatcher
implements Predicate<MethodNode> {
    @Nonnull
    private final ClassName clsName;
    @Nonnull
    private final String description;
    @Nonnull
    private final RefName refname;

    public MethodMatcher(@Nonnull ClassName clsName, @Nonnull String description, @Nonnull RefName refname) {
        this.clsName = clsName;
        this.description = description;
        this.refname = refname;
    }

    public boolean match(@Nonnull String methodName, @Nonnull String methodDesc) {
        if (CompatFMLDeobfuscatingRemapper.useMcpNames()) {
            return methodName.equals(this.refname.mcpName()) && methodDesc.equals(this.description);
        }
        String srgMethodDesc = CompatFMLDeobfuscatingRemapper.mapMethodDesc(methodDesc);
        if (!srgMethodDesc.equals(this.description)) {
            return false;
        }
        String srgMethodName = CompatFMLDeobfuscatingRemapper.mapMethodName(CompatFMLDeobfuscatingRemapper.unmap(this.clsName.getBytecodeName()), methodName, methodDesc);
        return srgMethodName.equals(this.refname.srgName());
    }

    @Override
    public boolean test(MethodNode node) {
        return this.match(node.name, node.desc);
    }

    public Predicate<AbstractInsnNode> insnMatcher() {
        return node -> node instanceof MethodInsnNode && this.match(((MethodInsnNode)node).name, ((MethodInsnNode)node).desc);
    }

    @Nonnull
    public String toString() {
        return String.format("Mathod Matcher: %s.%s %s", this.clsName.getBytecodeName(), this.refname, this.description);
    }
}

