/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.RefName;
import net.teamfruit.emojicord.compat.CompatFMLDeobfuscatingRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;

public class FieldMatcher
implements Predicate<FieldNode> {
    @Nonnull
    private final ClassName clsName;
    @Nonnull
    private final String description;
    @Nonnull
    private final RefName refname;

    public FieldMatcher(@Nonnull ClassName clsName, @Nonnull String description, @Nonnull RefName refname) {
        this.clsName = clsName;
        this.description = description;
        this.refname = refname;
    }

    public boolean match(@Nonnull String fieldName, @Nonnull String fieldDesc) {
        if (CompatFMLDeobfuscatingRemapper.useMcpNames()) {
            return fieldName.equals(this.refname.mcpName()) && fieldDesc.equals(this.description);
        }
        String srgDesc = CompatFMLDeobfuscatingRemapper.mapDesc(fieldDesc);
        if (!srgDesc.equals(this.description)) {
            return false;
        }
        String srgFieldName = CompatFMLDeobfuscatingRemapper.mapFieldName(CompatFMLDeobfuscatingRemapper.unmap(this.clsName.getBytecodeName()), fieldName, fieldDesc);
        return srgFieldName.equals(this.refname.srgName());
    }

    @Override
    public boolean test(FieldNode node) {
        return this.match(node.name, node.desc);
    }

    public Predicate<AbstractInsnNode> insnMatcher() {
        return node -> node instanceof FieldInsnNode && this.match(((FieldInsnNode)node).name, ((FieldInsnNode)node).desc);
    }

    @Nonnull
    public String toString() {
        return String.format("Field Matcher: %s.%s %s", this.clsName.getBytecodeName(), this.refname, this.description);
    }
}

