/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.stream.Collectors;
import net.teamfruit.emojicord.Log;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ASMValidate {
    private ASMValidate() {
    }

    public void test(String name) {
    }

    public void test(String name, boolean condition) {
    }

    public void tests(String name, int occurrences) {
    }

    public void tests(String name, boolean condition, int occurrences) {
    }

    public void check(String name) {
    }

    public void checks(String name) {
    }

    public void validate() {
    }

    public static ASMValidate create(String testName) {
        if (ASMValidateImpl.IsEnabled) {
            return new ASMValidateImpl(testName);
        }
        return new ASMValidate();
    }

    private static class ASMValidateImpl
    extends ASMValidate {
        public static final boolean IsEnabled;
        private final String testName;
        private final Multiset<String> cases = HashMultiset.create();

        public ASMValidateImpl(String testName) {
            this.testName = testName;
            Log.log.info("ASM Validator Start: " + testName);
        }

        @Override
        public void test(String name) {
            this.tests(name, 1);
        }

        @Override
        public void test(String name, boolean condition) {
            this.tests(name, condition, 1);
        }

        @Override
        public void tests(String name, int occurrences) {
            this.tests(name, true, occurrences);
        }

        @Override
        public void tests(String name, boolean condition, int occurrences) {
            if (condition) {
                this.cases.add((Object)name, occurrences);
            }
        }

        @Override
        public void check(String name) {
            Validate.validState((boolean)this.cases.remove((Object)name), (String)"ASM Assertion Error in %s: Too many checkpoints: %s", (Object[])new Object[]{this.testName, name});
        }

        @Override
        public void checks(String name) {
            this.cases.remove((Object)name);
        }

        @Override
        public void validate() {
            if (this.cases.size() > 0) {
                throw new IllegalStateException(String.format("ASM Assertion Error in %s: Not enough checkpoints: %s", this.testName, this.cases.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting())).entrySet().stream().map(e -> (Long)e.getValue() == 1L ? (String)e.getKey() : String.format("%s(%d)", e.getKey(), e.getValue())).collect(Collectors.joining(", "))));
            }
            Log.log.info("ASM Validator Passed: " + this.testName);
        }

        static {
            boolean bl = IsEnabled = !StringUtils.isEmpty((CharSequence)System.getenv("TEAMFRUIT_DEV"));
            if (IsEnabled) {
                Log.log.info("ASM Validator Enabled");
            } else {
                Log.log.debug("ASM Validator Disabled");
            }
        }
    }
}

