/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import java.util.function.Supplier;
import net.teamfruit.emojicord.asm.ASMDeobfNames;
import net.teamfruit.emojicord.asm.lib.ASMValidate;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.DescHelper;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.MethodMatcher;
import net.teamfruit.emojicord.compat.CompatBaseVersion;
import net.teamfruit.emojicord.compat.CompatVersion;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SendChatMessageTransform
implements INodeTreeTransformer {
    @Override
    public ClassName getClassName() {
        if (CompatVersion.version().older(CompatBaseVersion.V7)) {
            return ClassName.of("net.minecraft.client.gui.GuiChat");
        }
        if (CompatVersion.version().older(CompatBaseVersion.V13)) {
            return ClassName.of("net.minecraft.client.gui.GuiScreen");
        }
        return ClassName.of("net.minecraft.client.gui.screen.Screen");
    }

    @Override
    public ClassNode apply(ClassNode node) {
        ASMValidate validator = ASMValidate.create(this.getSimpleName());
        validator.test("sendChatMessage", CompatVersion.version().older(CompatBaseVersion.V10));
        if (CompatVersion.version().older(CompatBaseVersion.V10)) {
            MethodMatcher matcher = ((Supplier<MethodMatcher>)() -> {
                if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                    return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, ClassName.of("java.lang.String")), ASMDeobfNames.GuiChatSendChatMessage);
                }
                return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, ClassName.of("java.lang.String"), Boolean.TYPE), ASMDeobfNames.GuiScreenSendChatMessage);
            }).get();
            node.methods.stream().filter(matcher).forEach(method -> {
                InsnList insertion = new InsnList();
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.compat.ClientChatEvent").getBytecodeName(), "onClientSendMessage", DescHelper.toDescMethod(ClassName.of("java.lang.String"), ClassName.of("java.lang.String")), false));
                insertion.add((AbstractInsnNode)new VarInsnNode(58, 1));
                method.instructions.insert(insertion);
                validator.check("sendChatMessage");
            });
        }
        validator.validate();
        return node;
    }
}

