/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.teamfruit.emojicord.asm.ASMDeobfNames;
import net.teamfruit.emojicord.asm.EmojicordTransformer;
import net.teamfruit.emojicord.asm.lib.ASMValidate;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.DescHelper;
import net.teamfruit.emojicord.asm.lib.FieldMatcher;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.MethodMatcher;
import net.teamfruit.emojicord.asm.lib.RefName;
import net.teamfruit.emojicord.asm.lib.VisitorHelper;
import net.teamfruit.emojicord.compat.CompatBaseVersion;
import net.teamfruit.emojicord.compat.CompatVersion;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiTextFieldTransform
implements INodeTreeTransformer {
    @Override
    public ClassName getClassName() {
        if (CompatVersion.version().older(CompatBaseVersion.V13)) {
            return ClassName.of("net.minecraft.client.gui.GuiTextField");
        }
        return ClassName.of("net.minecraft.client.gui.widget.TextFieldWidget");
    }

    @Override
    public ClassNode apply(ClassNode node) {
        Predicate<MethodNode> matcher;
        int o;
        ASMValidate validator = ASMValidate.create(this.getSimpleName());
        validator.test("drawTextBox.suggestion", !CompatVersion.version().newer(CompatBaseVersion.V13));
        validator.test("drawTextBox.suggestion.field", !CompatVersion.version().newer(CompatBaseVersion.V13));
        int n = o = EmojicordTransformer.intelliInputDeferred.hasTarget() ? 1 : 0;
        if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
            matcher = new FieldMatcher(this.getClassName(), DescHelper.toDesc(ClassName.of("java.lang.String")), RefName.name("suggestion"));
            if (node.fields.stream().noneMatch(matcher)) {
                node.fields.add(new FieldNode(1, "suggestion", DescHelper.toDesc(ClassName.of("java.lang.String")), null, null));
                validator.check("drawTextBox.suggestion.field");
            }
        }
        matcher = ((Supplier<MethodMatcher>)() -> {
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, new Object[0]), ASMDeobfNames.GuiTextFieldDrawTextBox);
            }
            return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE), ASMDeobfNames.GuiTextFieldDrawTextField);
        }).get();
        node.methods.stream().filter(matcher).forEach(method -> {
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                MethodMatcher matcher0 = ((Supplier<MethodMatcher>)() -> {
                    if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                        return new MethodMatcher(ClassName.of("net.minecraft.client.gui.FontRenderer"), DescHelper.toDescMethod(Integer.TYPE, ClassName.of("java.lang.String"), Integer.TYPE, Integer.TYPE, Integer.TYPE), ASMDeobfNames.FontRendererDrawStringWithShadow);
                    }
                    return new MethodMatcher(ClassName.of("net.minecraft.client.gui.FontRenderer"), DescHelper.toDescMethod(Integer.TYPE, ClassName.of("java.lang.String"), Float.TYPE, Float.TYPE, Integer.TYPE), ASMDeobfNames.FontRendererDrawStringWithShadow);
                }).get();
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).filter(e -> {
                    if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                        return (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 182 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 25 && (e = e.getPrevious()).getOpcode() == 180 && (e = e.getPrevious()).getOpcode() == 25;
                    }
                    return (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 134 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 134 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 182 && (e = e.getPrevious()).getOpcode() == 21 && (e = e.getPrevious()).getOpcode() == 25 && (e = e.getPrevious()).getOpcode() == 180 && (e = e.getPrevious()).getOpcode() == 25;
                }).findFirst().ifPresent(marker -> {
                    AbstractInsnNode marker0 = marker.getNext().getNext().getNext();
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.GuiTextFieldFontRenderer.name(), DescHelper.toDesc(ClassName.of("net.minecraft.client.gui.FontRenderer"))));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, o + 10));
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), "suggestion", DescHelper.toDesc(ClassName.of("java.lang.String"))));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, o + 11));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, o + 8));
                    insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.compat.CompatGui$CompatTextFieldWidget").getBytecodeName(), "renderSuggestion", DescHelper.toDescMethod(Void.TYPE, ClassName.of("net.minecraft.client.gui.FontRenderer"), Boolean.TYPE, ClassName.of("java.lang.String"), Integer.TYPE, Integer.TYPE), false));
                    method.instructions.insert(marker0, insertion);
                    validator.check("drawTextBox.suggestion");
                });
            }
        });
        validator.validate();
        return node;
    }
}

