/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.Util;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.addons.AddonForge;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.elements.stevescarts2.ElementCage;
import io.github.drmanganese.topaddons.reference.Colors;
import io.github.drmanganese.topaddons.styles.ProgressStyleTOPAddonGrey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.engines.ModuleCoalBase;
import vswe.stevescarts.modules.engines.ModuleEngine;
import vswe.stevescarts.modules.engines.ModuleSolarBase;
import vswe.stevescarts.modules.engines.ModuleThermalBase;
import vswe.stevescarts.modules.realtimers.ModuleCage;
import vswe.stevescarts.modules.storages.ModuleStorage;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.tools.ModuleTool;

@TOPAddon(dependency="stevescarts")
public class AddonStevesCarts2
extends AddonBlank {
    private final String[] priorities = new String[]{TextFormatting.GREEN + "{*topaddons.stevescarts2:priority_high*}", TextFormatting.GOLD + "{*topaddons.stevescarts2:priority_medium*}", TextFormatting.YELLOW + "{*topaddons.stevescarts2:priority_low*}", TextFormatting.RED + "{*topaddons.stevescarts2:priority_disabled*}"};
    private boolean showChestsContents = true;

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler assembler = (TileEntityCartAssembler)tile;
            if (assembler.getIsAssembling()) {
                AddonStevesCarts2.textPrefixed(probeInfo, "{*topaddons.stevescarts2:assembly_time*}", Util.hoursMinsSecsFromTicks(Math.round((float)(assembler.getMaxAssemblingTime() - assembler.getAssemblingTime()) / assembler.getEfficiency()), 'h', 'm', 's'));
            }
            probeInfo.progress(assembler.getFuelLevel(), assembler.getMaxFuelLevel(), (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Fuel: ").suffix("/" + assembler.getMaxFuelLevel()).filledColor(-14957584).alternateFilledColor(-15562584));
        }
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof EntityMinecartModular) {
            ArrayList<ModuleTank> tanks = new ArrayList<ModuleTank>();
            ArrayList<ModuleEngine> engines = new ArrayList<ModuleEngine>();
            ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
            ArrayList<ModuleBase> otherModules = new ArrayList<ModuleBase>();
            ItemStack cage = ItemStack.field_190927_a;
            ModuleTool tool = null;
            for (ModuleBase moduleBase : ((EntityMinecartModular)entity).getModules()) {
                if (moduleBase instanceof ModuleTank) {
                    tanks.add((ModuleTank)moduleBase);
                    continue;
                }
                if (moduleBase instanceof ModuleCage) {
                    cage = moduleBase.getData().getItemStack();
                    continue;
                }
                if (moduleBase instanceof ModuleEngine) {
                    engines.add((ModuleEngine)moduleBase);
                    continue;
                }
                if (moduleBase instanceof ModuleTool) {
                    tool = (ModuleTool)moduleBase;
                    continue;
                }
                if (moduleBase instanceof ModuleStorage && this.showChestsContents) {
                    for (int i = 0; i < moduleBase.getInventorySize(); ++i) {
                        ItemStack stack = moduleBase.getStack(i);
                        if (stack.func_190926_b()) continue;
                        boolean merged = false;
                        for (ItemStack itemStack : inventory) {
                            if (!itemStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack)) continue;
                            itemStack.func_190920_e(itemStack.func_190916_E() + stack.func_190916_E());
                            merged = true;
                            break;
                        }
                        if (merged) continue;
                        inventory.add(stack.func_77946_l());
                    }
                    continue;
                }
                if (!((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("stevesOtherModules")) continue;
                otherModules.add(moduleBase);
            }
            if (tool != null) {
                int durability = 100 * tool.getCurrentDurability() / tool.getMaxDurability();
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(tool.getData().getItemStack()).text(tool.getData().getItemStack().func_82833_r() + " (" + durability + "%)");
            }
            if (mode == ProbeMode.EXTENDED && inventory.size() > 0) {
                this.showItemStackRows(probeInfo, inventory, 9, probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)));
            }
            if (!cage.func_190926_b()) {
                if (((EntityMinecartModular)entity).getCartRider() != null) {
                    Entity passenger = ((EntityMinecartModular)entity).getCartRider();
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).element((IElement)new ElementCage(AddonStevesCarts2.getElementId(player, "steves_cage"), passenger)).text(passenger.func_145748_c_().func_150254_d());
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(cage).text("{*topaddons:tank_empty*}");
                }
            }
            for (ModuleTank tank : tanks) {
                if (tank.getFluid() != null) {
                    AddonForge.addTankElement(probeInfo, tank.getData().getName(), tank.getFluid().getLocalizedName(), tank.getFluid().amount, tank.getInfo().capacity, "mB", Colors.getHashFromFluid(tank.getFluid()), mode, player);
                    continue;
                }
                AddonForge.addTankElement(probeInfo, tank.getData().getName(), "", 0, 0, "mB", 0, mode, player);
            }
            if (engines.size() > 0) {
                IProbeInfo engineVert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-8947849)).spacing(0));
                engines.sort(Comparator.comparingInt(ModuleEngine::getPriority));
                for (ModuleEngine engine : engines) {
                    IProbeInfo engineHori = engineVert.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(engine.getData().getItemStack()).vertical(probeInfo.defaultLayoutStyle().spacing(-1));
                    int fuel = engine.getTotalFuel();
                    if (engine instanceof ModuleThermalBase) {
                        if (engine.getCart().drain(FluidRegistry.WATER, 1, false) == 0) {
                            engineHori.text("{*topaddons.stevescarts2:engine_outofwater*}");
                        } else if (engine.getCart().drain(FluidRegistry.LAVA, 1, false) == 0) {
                            engineHori.text("{*topaddons.stevescarts2:engine_outoflava*}");
                        } else {
                            engineHori.text("{*topaddons.stevescarts2:engine_powered*}");
                        }
                    } else if (engine instanceof ModuleSolarBase) {
                        engineHori.text(fuel > 0 ? String.valueOf(fuel) : "{*topaddons.stevescarts2:engine_outofpower*}");
                    } else if (engine instanceof ModuleCoalBase) {
                        engineHori.text(fuel > 0 ? engine.getFuelLevel() + " (" + Util.metricPrefixise(fuel) + ")" : "{*topaddons.stevescarts2:engine_outoffuel*}");
                    }
                    engineHori.text(this.priorities[engine.getPriority()]);
                }
            }
            if (mode == ProbeMode.EXTENDED && otherModules.size() > 0) {
                this.showItemStackRows(probeInfo, otherModules.stream().map(m -> m.getData().getItemStack()).collect(Collectors.toList()), 9);
            }
        }
    }

    @Override
    public void registerElements() {
        this.registerElement("steves_cage", ElementCage::new);
    }

    @Override
    public void updateConfigs(Configuration config) {
        this.showChestsContents = config.get("stevescarts", "showChestsContents", true, "Show cart inventory contents in TOP.").setLanguageKey("topaddons.config:stevescarts_chest_contents").getBoolean();
    }

    @Override
    public List<IEntityDisplayOverride> getEntityDisplayOverrides() {
        return Collections.singletonList((mode, probeInfo, player, world, entity, data) -> {
            if (entity instanceof EntityMinecartModular) {
                EntityMinecartModular cart = (EntityMinecartModular)entity;
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().entity((Entity)cart).vertical().text(cart.getCartName()).text(TextStyleClass.MODNAME + Tools.getModName((Entity)entity));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity((Entity)cart).text(cart.func_145748_c_().func_150254_d());
                }
                return true;
            }
            return false;
        });
    }
}

