/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

@SideOnly(value=Side.CLIENT)
public class TextHelper {
    public static String getFormattedText(String string) {
        return string.replaceAll("&", "\u00a7");
    }

    public static String localize(String input, Object ... format) {
        return I18n.func_135052_a((String)input, (Object[])format);
    }

    public static String localizeEffect(String input, Object ... format) {
        return TextHelper.getFormattedText(TextHelper.localize(input, format));
    }

    public static String[] localizeAll(String[] input) {
        return (String[])Arrays.stream(input).map(s -> TextHelper.localize(s, new Object[0])).toArray(String[]::new);
    }

    public static String[] localizeAllEffect(String[] input) {
        return (String[])Arrays.stream(input).map(s -> TextHelper.localizeEffect(s, new Object[0])).toArray(String[]::new);
    }

    public static ArrayList<String> localizeAll(List<String> input) {
        ArrayList<String> ret = new ArrayList<String>(input.size());
        IntStream.range(0, input.size()).forEachOrdered(i -> ret.add(i, TextHelper.localize((String)input.get(i), new Object[0])));
        return ret;
    }

    public static ArrayList<String> localizeAllEffect(List<String> input) {
        ArrayList<String> ret = new ArrayList<String>(input.size());
        IntStream.range(0, input.size()).forEachOrdered(i -> ret.add(i, TextHelper.localizeEffect((String)input.get(i), new Object[0])));
        return ret;
    }

    public static String[] cutLongString(String string, int characters) {
        return WordUtils.wrap((String)string, (int)characters, (String)"/cut", (boolean)false).split("/cut");
    }

    public static String[] cutLongString(String string) {
        return TextHelper.cutLongString(string, 30);
    }
}

