/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text.renderer;

import me.lucko.spark.lib.adventure.text.BlockNBTComponent;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.EntityNBTComponent;
import me.lucko.spark.lib.adventure.text.KeybindComponent;
import me.lucko.spark.lib.adventure.text.NBTComponent;
import me.lucko.spark.lib.adventure.text.ScoreComponent;
import me.lucko.spark.lib.adventure.text.SelectorComponent;
import me.lucko.spark.lib.adventure.text.StorageNBTComponent;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.TranslatableComponent;
import me.lucko.spark.lib.adventure.text.renderer.ComponentRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractComponentRenderer<C>
implements ComponentRenderer<C> {
    @Override
    public @NonNull Component render(@NonNull Component component, @NonNull C context) {
        if (component instanceof TextComponent) {
            return this.renderText((TextComponent)component, context);
        }
        if (component instanceof TranslatableComponent) {
            return this.renderTranslatable((TranslatableComponent)component, context);
        }
        if (component instanceof KeybindComponent) {
            return this.renderKeybind((KeybindComponent)component, context);
        }
        if (component instanceof ScoreComponent) {
            return this.renderScore((ScoreComponent)component, context);
        }
        if (component instanceof SelectorComponent) {
            return this.renderSelector((SelectorComponent)component, context);
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                return this.renderBlockNbt((BlockNBTComponent)component, context);
            }
            if (component instanceof EntityNBTComponent) {
                return this.renderEntityNbt((EntityNBTComponent)component, context);
            }
            if (component instanceof StorageNBTComponent) {
                return this.renderStorageNbt((StorageNBTComponent)component, context);
            }
        }
        return component;
    }

    protected abstract @NonNull Component renderBlockNbt(@NonNull BlockNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderEntityNbt(@NonNull EntityNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderStorageNbt(@NonNull StorageNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderKeybind(@NonNull KeybindComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderScore(@NonNull ScoreComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderSelector(@NonNull SelectorComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderText(@NonNull TextComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderTranslatable(@NonNull TranslatableComponent var1, @NonNull C var2);
}

