/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.activitylog.ActivityLog;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerBuilder;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.ThreadNodeOrder;
import me.lucko.spark.common.sampler.async.AsyncSampler;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.common.util.MethodDisambiguator;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.okhttp3.MediaType;

public class SamplerModule
implements CommandModule {
    private static final MediaType SPARK_SAMPLER_MEDIA_TYPE = MediaType.parse("application/x-spark-sampler");
    private Sampler activeSampler = null;

    @Override
    public void close() {
        if (this.activeSampler != null) {
            this.activeSampler.stop();
            this.activeSampler = null;
        }
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("profiler", "sampler").argumentUsage("info", null).argumentUsage("stop", null).argumentUsage("cancel", null).argumentUsage("interval", "interval millis").argumentUsage("thread", "thread name").argumentUsage("only-ticks-over", "tick length millis").argumentUsage("timeout", "timeout seconds").argumentUsage("regex --thread", "thread regex").argumentUsage("combine-all", null).argumentUsage("not-combined", null).argumentUsage("force-java-sampler", null).argumentUsage("stop --comment", "comment").argumentUsage("stop --order-by-time", null).executor((platform, sender, resp, arguments) -> {
            double intervalMillis;
            if (arguments.boolFlag("info")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(Component.text("There isn't an active profiler running."));
                } else {
                    long timeout = this.activeSampler.getEndTime();
                    if (timeout == -1L) {
                        resp.replyPrefixed(Component.text("There is an active profiler currently running, with no defined timeout."));
                    } else {
                        long timeoutDiff = (timeout - System.currentTimeMillis()) / 1000L;
                        resp.replyPrefixed(Component.text("There is an active profiler currently running, due to timeout in " + timeoutDiff + " seconds."));
                    }
                    long runningTime = (System.currentTimeMillis() - this.activeSampler.getStartTime()) / 1000L;
                    resp.replyPrefixed(Component.text("It has been profiling for " + runningTime + " seconds so far."));
                }
                return;
            }
            if (arguments.boolFlag("cancel")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(Component.text("There isn't an active profiler running."));
                } else {
                    this.close();
                    resp.broadcastPrefixed(Component.text("The active profiler has been cancelled.", (TextColor)NamedTextColor.GOLD));
                }
                return;
            }
            if (arguments.boolFlag("stop") || arguments.boolFlag("upload")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(Component.text("There isn't an active profiler running."));
                } else {
                    this.activeSampler.stop();
                    resp.broadcastPrefixed(Component.text("The active profiler has been stopped! Uploading results..."));
                    ThreadNodeOrder threadOrder = arguments.boolFlag("order-by-time") ? ThreadNodeOrder.BY_TIME : ThreadNodeOrder.BY_NAME;
                    String comment = (String)Iterables.getFirst(arguments.stringFlag("comment"), null);
                    MethodDisambiguator methodDisambiguator = new MethodDisambiguator();
                    MergeMode mergeMode = arguments.boolFlag("separate-parent-calls") ? MergeMode.separateParentCalls(methodDisambiguator) : MergeMode.sameMethod(methodDisambiguator);
                    this.handleUpload(platform, resp, this.activeSampler, threadOrder, comment, mergeMode);
                    this.activeSampler = null;
                }
                return;
            }
            int timeoutSeconds = arguments.intFlag("timeout");
            if (timeoutSeconds != -1 && timeoutSeconds <= 10) {
                resp.replyPrefixed(Component.text("The specified timeout is not long enough for accurate results to be formed. Please choose a value greater than 10.", (TextColor)NamedTextColor.RED));
                return;
            }
            if (timeoutSeconds != -1 && timeoutSeconds < 30) {
                resp.replyPrefixed(Component.text("The accuracy of the output will significantly improve when the profiler is able to run for longer periods. Consider setting a timeout value over 30 seconds."));
            }
            if ((intervalMillis = arguments.doubleFlag("interval")) <= 0.0) {
                intervalMillis = 4.0;
            }
            boolean ignoreSleeping = arguments.boolFlag("ignore-sleeping");
            boolean ignoreNative = arguments.boolFlag("ignore-native");
            boolean forceJavaSampler = arguments.boolFlag("force-java-sampler");
            Set<String> threads = arguments.stringFlag("thread");
            ThreadDumper threadDumper = threads.isEmpty() ? platform.getPlugin().getDefaultThreadDumper() : (threads.contains("*") ? ThreadDumper.ALL : (arguments.boolFlag("regex") ? new ThreadDumper.Regex(threads) : new ThreadDumper.Specific(threads)));
            ThreadGrouper threadGrouper = arguments.boolFlag("combine-all") ? ThreadGrouper.AS_ONE : (arguments.boolFlag("not-combined") ? ThreadGrouper.BY_NAME : ThreadGrouper.BY_POOL);
            int ticksOver = arguments.intFlag("only-ticks-over");
            TickHook tickHook = null;
            if (ticksOver != -1 && (tickHook = platform.getTickHook()) == null) {
                resp.replyPrefixed(Component.text("Tick counting is not supported!", (TextColor)NamedTextColor.RED));
                return;
            }
            if (this.activeSampler != null) {
                resp.replyPrefixed(Component.text("An active profiler is already running."));
                return;
            }
            resp.broadcastPrefixed(Component.text("Initializing a new profiler, please wait..."));
            SamplerBuilder builder = new SamplerBuilder();
            builder.threadDumper(threadDumper);
            builder.threadGrouper(threadGrouper);
            if (timeoutSeconds != -1) {
                builder.completeAfter(timeoutSeconds, TimeUnit.SECONDS);
            }
            builder.samplingInterval(intervalMillis);
            builder.ignoreSleeping(ignoreSleeping);
            builder.ignoreNative(ignoreNative);
            builder.forceJavaSampler(forceJavaSampler);
            if (ticksOver != -1) {
                builder.ticksOver(ticksOver, tickHook);
            }
            Sampler sampler = this.activeSampler = builder.start();
            resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Profiler now active!", (TextColor)NamedTextColor.GOLD))).append((Component)Component.space())).append((Component)Component.text("(" + (sampler instanceof AsyncSampler ? "async" : "built-in java") + ")", (TextColor)NamedTextColor.DARK_GRAY))).build());
            if (timeoutSeconds == -1) {
                resp.broadcastPrefixed(Component.text("Use '/" + platform.getPlugin().getCommandName() + " profiler --stop' to stop profiling and upload the results."));
            } else {
                resp.broadcastPrefixed(Component.text("The results will be automatically returned after the profiler has been running for " + timeoutSeconds + " seconds."));
            }
            CompletableFuture<? extends Sampler> future = this.activeSampler.getFuture();
            future.whenCompleteAsync((s, throwable) -> {
                if (throwable != null) {
                    resp.broadcastPrefixed(Component.text("Profiler operation failed unexpectedly. Error: " + throwable.toString(), (TextColor)NamedTextColor.RED));
                    throwable.printStackTrace();
                }
            });
            future.whenCompleteAsync((s, throwable) -> {
                if (sampler == this.activeSampler) {
                    this.activeSampler = null;
                }
            });
            if (timeoutSeconds != -1) {
                ThreadNodeOrder threadOrder = arguments.boolFlag("order-by-time") ? ThreadNodeOrder.BY_TIME : ThreadNodeOrder.BY_NAME;
                String comment = (String)Iterables.getFirst(arguments.stringFlag("comment"), null);
                MethodDisambiguator methodDisambiguator = new MethodDisambiguator();
                MergeMode mergeMode = arguments.boolFlag("separate-parent-calls") ? MergeMode.separateParentCalls(methodDisambiguator) : MergeMode.sameMethod(methodDisambiguator);
                future.thenAcceptAsync(s -> {
                    resp.broadcastPrefixed(Component.text("The active profiler has completed! Uploading results..."));
                    this.handleUpload(platform, resp, (Sampler)s, threadOrder, comment, mergeMode);
                });
            }
        }).tabCompleter((platform, sender, arguments) -> {
            if (arguments.contains("--info") || arguments.contains("--cancel")) {
                return Collections.emptyList();
            }
            if (arguments.contains("--stop") || arguments.contains("--upload")) {
                return TabCompleter.completeForOpts(arguments, "--order-by-time", "--comment");
            }
            ArrayList<String> opts = new ArrayList<String>(Arrays.asList("--info", "--stop", "--cancel", "--timeout", "--regex", "--combine-all", "--not-combined", "--interval", "--only-ticks-over", "--force-java-sampler"));
            opts.removeAll(arguments);
            opts.add("--thread");
            return TabCompleter.create().from(0, CompletionSupplier.startsWith(opts)).complete(arguments);
        }).build());
    }

    private void handleUpload(SparkPlatform platform, CommandResponseHandler resp, Sampler sampler, ThreadNodeOrder threadOrder, String comment, MergeMode mergeMode) {
        platform.getPlugin().executeAsync(() -> {
            byte[] output = sampler.formCompressedDataPayload(platform.getPlugin().getPlatformInfo(), resp.sender(), threadOrder, comment, mergeMode);
            try {
                String key = SparkPlatform.BYTEBIN_CLIENT.postContent(output, SPARK_SAMPLER_MEDIA_TYPE, false).key();
                String url = "https://spark.lucko.me/" + key;
                resp.broadcastPrefixed(Component.text("Profiler results:", (TextColor)NamedTextColor.GOLD));
                resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color(NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl(url))).build());
                platform.getActivityLog().addToLog(ActivityLog.Activity.urlActivity(resp.sender(), System.currentTimeMillis(), "Profiler", url));
            }
            catch (IOException e) {
                resp.broadcastPrefixed(Component.text("An error occurred whilst uploading the results.", (TextColor)NamedTextColor.RED));
                e.printStackTrace();
            }
        });
    }
}

