/*
 * Decompiled with CFR 0.152.
 */
package io.sommers.packmode.compat.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import io.sommers.packmode.api.PackModeAPI;
import java.util.Arrays;
import java.util.List;

public class PackModePreprocessor
extends PreprocessorActionBase {
    private static final String PREPROCESSOR_NAME = "packmode";
    private List<String> packModes = Lists.newArrayList();

    public PackModePreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        preprocessorLine = preprocessorLine.replace("#packmode", "");
        this.packModes.addAll(Lists.newArrayList((Object[])preprocessorLine.trim().split(" ")));
    }

    public void executeActionOnFind(ScriptFile scriptFile) {
        if (!this.packModes.contains(PackModeAPI.getInstance().getCurrentPackMode())) {
            CraftTweakerAPI.logInfo((String)("Ignoring script " + scriptFile + " as current pack mode " + PackModeAPI.getInstance().getCurrentPackMode() + " is not in the scripts pack modes " + Arrays.toString(this.packModes.toArray())));
            scriptFile.setParsingBlocked(true);
            scriptFile.setCompileBlocked(true);
            scriptFile.setExecutionBlocked(true);
        }
    }

    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }
}

