/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.predicate;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCBlockInfo;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCBlockWorldState;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCMetaTileEntity;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IBlockInfo;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMetaTileEntity;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMultiblockAbility;
import eutros.multiblocktweaker.crafttweaker.predicate.ICandidates;
import eutros.multiblocktweaker.crafttweaker.predicate.IMTEPredicate;
import eutros.multiblocktweaker.crafttweaker.predicate.IPredicate;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternStringError;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenConstructor;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="mods.gregtech.multiblock.CTPredicate")
@ZenRegister
public class CTTraceabilityPredicate {
    TraceabilityPredicate internal;
    public static CTTraceabilityPredicate ANY = new CTTraceabilityPredicate(TraceabilityPredicate.ANY);
    public static CTTraceabilityPredicate AIR = new CTTraceabilityPredicate(TraceabilityPredicate.AIR);

    public CTTraceabilityPredicate(TraceabilityPredicate internal) {
        this.internal = internal;
    }

    public CTTraceabilityPredicate(Predicate<BlockWorldState> predicate, Supplier<BlockInfo[]> candidates) {
        this(new TraceabilityPredicate(predicate, candidates));
    }

    @ZenConstructor
    public CTTraceabilityPredicate(IPredicate predicate, ICandidates candidates) {
        this(new TraceabilityPredicate(state -> predicate.test(new MCBlockWorldState((BlockWorldState)state)), () -> (BlockInfo[])Arrays.stream(candidates.get()).map(IBlockInfo::getInternal).toArray(BlockInfo[]::new)));
    }

    @ZenConstructor
    public CTTraceabilityPredicate() {
        this(new TraceabilityPredicate());
    }

    @ZenMethod
    public static CTTraceabilityPredicate getAny() {
        return ANY;
    }

    @ZenMethod
    public static CTTraceabilityPredicate getAir() {
        return AIR;
    }

    @ZenMethod
    public static CTTraceabilityPredicate getCoils() {
        return new CTTraceabilityPredicate(new TraceabilityPredicate(blockWorldState -> {
            net.minecraft.block.state.IBlockState blockState = blockWorldState.getBlockState();
            if (blockState.func_177230_c() instanceof BlockWireCoil) {
                BlockWireCoil blockWireCoil = (BlockWireCoil)blockState.func_177230_c();
                BlockWireCoil.CoilType coilType = (BlockWireCoil.CoilType)blockWireCoil.getState(blockState);
                Object currentCoilType = blockWorldState.getMatchContext().getOrPut("CoilType", (Object)coilType);
                blockWorldState.getMatchContext().getOrPut("coils_temperature", (Object)coilType.getCoilTemperature());
                if (!currentCoilType.toString().equals(coilType.func_176610_l())) {
                    blockWorldState.setError((PatternError)new PatternStringError("gregtech.multiblock.pattern.error.coils"));
                    return false;
                }
                ((LinkedList)blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList())).add(blockWorldState.getPos());
                return true;
            }
            return false;
        }, () -> (BlockInfo[])ArrayUtils.addAll((Object[])Arrays.stream(BlockWireCoil.CoilType.values()).map(type -> new BlockInfo(MetaBlocks.WIRE_COIL.getState((Enum)type), null)).toArray(BlockInfo[]::new), (Object[])new BlockInfo[0])).addTooltips(new String[]{"gregtech.multiblock.pattern.error.coils"}));
    }

    @ZenMethod
    public static CTTraceabilityPredicate mtePredicate(IMTEPredicate predicate, ICandidates candidates) {
        return new CTTraceabilityPredicate(blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getInternal().getTileEntity();
            if (!(tileEntity instanceof MetaTileEntityHolder)) {
                return false;
            }
            MetaTileEntity metaTileEntity = ((MetaTileEntityHolder)tileEntity).getMetaTileEntity();
            if (metaTileEntity == null) {
                return false;
            }
            if (predicate.test(blockWorldState, new MCMetaTileEntity(metaTileEntity))) {
                if (metaTileEntity instanceof IMultiblockPart) {
                    Set partsFound = (Set)blockWorldState.getInternal().getMatchContext().getOrCreate("MultiblockParts", HashSet::new);
                    partsFound.add((IMultiblockPart)metaTileEntity);
                }
                return true;
            }
            return false;
        }, candidates);
    }

    private static Supplier<BlockInfo[]> getCandidates(Set<net.minecraft.block.state.IBlockState> allowedStates) {
        return () -> (BlockInfo[])allowedStates.stream().map(state -> new BlockInfo(state, null)).toArray(BlockInfo[]::new);
    }

    private static ICandidates getCandidates(MetaTileEntity ... metaTileEntities) {
        return () -> (IBlockInfo[])Arrays.stream(metaTileEntities).map(tile -> {
            MetaTileEntityHolder holder = new MetaTileEntityHolder();
            holder.setMetaTileEntity(tile);
            holder.getMetaTileEntity().setFrontFacing(EnumFacing.SOUTH);
            return new MCBlockInfo(new BlockInfo(MetaBlocks.MACHINE.func_176223_P(), (TileEntity)holder));
        }).toArray(IBlockInfo[]::new);
    }

    @ZenMethod
    public static CTTraceabilityPredicate states(IBlockState ... allowedStates) {
        HashSet<net.minecraft.block.state.IBlockState> states = new HashSet<net.minecraft.block.state.IBlockState>();
        for (IBlockState allowedState : allowedStates) {
            states.add(CraftTweakerMC.getBlockState((IBlockState)allowedState));
        }
        return new CTTraceabilityPredicate(blockWorldState -> {
            net.minecraft.block.state.IBlockState state = blockWorldState.getBlockState();
            if (state.func_177230_c() instanceof VariantActiveBlock) {
                ((LinkedList)blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList())).add(blockWorldState.getPos());
            }
            return states.contains(state);
        }, CTTraceabilityPredicate.getCandidates(states));
    }

    @ZenMethod
    public static CTTraceabilityPredicate blocks(IBlock ... blocks) {
        HashSet<Block> bloxx = new HashSet<Block>();
        for (IBlock block : blocks) {
            bloxx.add(CraftTweakerMC.getBlock((IBlockDefinition)block.getDefinition()));
        }
        return new CTTraceabilityPredicate(blockWorldState -> bloxx.contains(blockWorldState.getBlockState().func_177230_c()), CTTraceabilityPredicate.getCandidates(bloxx.stream().map(Block::func_176223_P).collect(Collectors.toSet())));
    }

    @ZenMethod
    public static CTTraceabilityPredicate items(IItemStack ... itemStacks) {
        return CTTraceabilityPredicate.blocks((IBlock[])Arrays.stream(itemStacks).map(IItemStack::asBlock).toArray(IBlock[]::new));
    }

    @ZenMethod
    public static CTTraceabilityPredicate liquids(ILiquidStack ... liquidStacks) {
        return CTTraceabilityPredicate.blocks((IBlock[])Arrays.stream(liquidStacks).map(ILiquidStack::getDefinition).map(ILiquidDefinition::getBlock).toArray(IBlock[]::new));
    }

    @ZenMethod
    public static CTTraceabilityPredicate abilities(IMultiblockAbility ... allowedAbilities) {
        Set abilities = Arrays.stream(allowedAbilities).map(IMultiblockAbility::getInternal).collect(Collectors.toSet());
        return CTTraceabilityPredicate.mtePredicate((state, tile) -> tile.getInternal() instanceof IMultiblockAbilityPart && abilities.contains(((IMultiblockAbilityPart)tile.getInternal()).getAbility()), CTTraceabilityPredicate.getCandidates((MetaTileEntity[])abilities.stream().flatMap(ability -> ((List)MultiblockAbility.REGISTRY.get(ability)).stream()).toArray(MetaTileEntity[]::new)));
    }

    @ZenMethod
    public static CTTraceabilityPredicate metaTileEntities(IMetaTileEntity ... allowedMTEs) {
        return CTTraceabilityPredicate.mtePredicate((state, mte) -> Arrays.stream(allowedMTEs).anyMatch(mte2 -> mte2.getInternal().metaTileEntityId == mte.getInternal().metaTileEntityId), CTTraceabilityPredicate.getCandidates((MetaTileEntity[])Arrays.stream(allowedMTEs).map(IMetaTileEntity::getInternal).toArray(MetaTileEntity[]::new)));
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.OR)
    public CTTraceabilityPredicate or(CTTraceabilityPredicate predicate) {
        this.internal = this.internal.or(predicate.internal);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setCenter() {
        this.internal = this.internal.setCenter();
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate sort() {
        this.internal = this.internal.sort();
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate addTooltips(String ... tips) {
        this.internal = this.internal.addTooltips(tips);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMinGlobalLimited(int min) {
        this.internal = this.internal.setMinGlobalLimited(min);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMinGlobalLimited(int min, int previewCount) {
        this.internal = this.internal.setMinGlobalLimited(min, previewCount);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMaxGlobalLimited(int max) {
        this.internal = this.internal.setMaxGlobalLimited(max);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMaxGlobalLimited(int max, int previewCount) {
        this.internal = this.internal.setMaxGlobalLimited(max, previewCount);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMinLayerLimited(int min) {
        this.internal = this.internal.setMinLayerLimited(min);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMinLayerLimited(int min, int previewCount) {
        this.internal = this.internal.setMinLayerLimited(min, previewCount);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMaxLayerLimited(int max) {
        this.internal = this.internal.setMaxLayerLimited(max);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setMaxLayerLimited(int max, int previewCount) {
        this.internal = this.internal.setMaxLayerLimited(max, previewCount);
        return this;
    }

    @ZenMethod
    public CTTraceabilityPredicate setPreviewCount(int count) {
        this.internal = this.internal.setPreviewCount(count);
        return this;
    }

    public TraceabilityPredicate toInternal() {
        return this.internal;
    }
}

