/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCMetaTileEntity;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIFluidHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIItemHandlerModifiable;
import eutros.multiblocktweaker.crafttweaker.predicate.CTTraceabilityPredicate;
import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.IMetaTileEntity")
@ZenRegister
public interface IMetaTileEntity {
    @NotNull
    public MetaTileEntity getInternal();

    @ZenMethod
    @Nullable
    public static IMetaTileEntity byId(@NotNull String id) {
        MetaTileEntity te;
        ResourceLocation loc = new ResourceLocation(id);
        if (loc.func_110624_b().equals("minecraft")) {
            loc = new ResourceLocation("multiblocktweaker", loc.func_110623_a());
        }
        if ((te = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a((Object)loc)) != null) {
            return new MCMetaTileEntity(te);
        }
        return null;
    }

    @ZenMethod
    public static IMetaTileEntity fromWorldPos(@Nonnull IWorld world, @Nonnull IBlockPos pos) {
        TileEntity te = CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos));
        if (te instanceof MetaTileEntityHolder && ((MetaTileEntityHolder)te).isValid()) {
            return new MCMetaTileEntity(((MetaTileEntityHolder)te).getMetaTileEntity());
        }
        return null;
    }

    @ZenMethod
    @ZenGetter(value="metaTileEntityId")
    public String getMetaTileEntityId();

    @ZenMethod
    @ZenGetter(value="world")
    public IWorld getWorld();

    @ZenMethod
    @ZenGetter(value="pos")
    public IBlockPos getPos();

    @ZenMethod
    @ZenGetter(value="offsetTimer")
    public long getOffsetTimer();

    @ZenMethod
    public String getMetaName();

    @ZenMethod
    public String getMetaFullName();

    @ZenMethod
    @ZenGetter(value="frontFacing")
    public IFacing getFrontFacing();

    @ZenMethod
    public void markDirty();

    @ZenMethod
    public boolean isFirstTick();

    @ZenMethod
    public int getInputRedstoneSignal(IFacing var1, boolean var2);

    @ZenMethod
    public boolean isBlockRedstonePowered();

    @ZenMethod
    public int getActualLightValue();

    @ZenMethod
    public void update();

    @ZenMethod
    public IItemStack getStackForm(int var1);

    @ZenMethod
    public boolean isOpaqueCube();

    @ZenMethod
    public int getLightOpacity();

    @ZenMethod
    public String getHarvestTool();

    @ZenMethod
    public int getHarvestLevel();

    @ZenMethod
    public int getOutputRedstoneSignal(IFacing var1);

    @ZenMethod
    public void setOutputRedstoneSignal(IFacing var1, int var2);

    @ZenMethod
    public void notifyBlockUpdate();

    @ZenMethod
    public void scheduleRenderUpdate();

    @ZenMethod
    public void setFrontFacing(IFacing var1);

    @ZenMethod
    public void setPaintingColor(int var1);

    @ZenMethod
    public void setFragile(boolean var1);

    @ZenMethod
    public boolean isValidFrontFacing(IFacing var1);

    @ZenMethod
    public boolean hasFrontFacing();

    @ZenMethod
    public boolean isValid();

    @ZenMethod
    public int getPaintingColor();

    @ZenMethod
    public IIItemHandlerModifiable getImportItems();

    @ZenMethod
    public IIItemHandlerModifiable getExportItems();

    @ZenMethod
    public IIFluidHandler getImportFluids();

    @ZenMethod
    public IIFluidHandler getExportFluids();

    @ZenMethod
    public List<IIItemHandlerModifiable> getNotifiedItemOutputList();

    @ZenMethod
    public List<IIItemHandlerModifiable> getNotifiedItemInputList();

    @ZenMethod
    public List<IIFluidHandler> getNotifiedFluidInputList();

    @ZenMethod
    public List<IIFluidHandler> getNotifiedFluidOutputList();

    @ZenMethod
    public boolean isFragile();

    @ZenMethod
    public boolean shouldDropWhenDestroyed();

    @ZenMethod
    public void toggleMuffled();

    @ZenMethod
    public boolean isMuffled();

    @ZenCaster
    public CTTraceabilityPredicate castCTPredicate();
}

