/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.brackethandler;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.zenscript.IBracketHandler;
import eutros.multiblocktweaker.crafttweaker.CustomMultiblock;
import eutros.multiblocktweaker.crafttweaker.MultiblockRegistry;
import java.util.Iterator;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class CustomMultiblockBracketHandler
implements IBracketHandler {
    private final IJavaMethod intGet;
    private final IJavaMethod stringGet = CraftTweakerAPI.getJavaMethod(CustomMultiblockBracketHandler.class, (String)"get", (Class[])new Class[]{String.class});

    public CustomMultiblockBracketHandler() {
        this.intGet = CraftTweakerAPI.getJavaMethod(CustomMultiblockBracketHandler.class, (String)"get", (Class[])new Class[]{Integer.TYPE});
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        Iterator<Token> it = tokens.iterator();
        if (it.next().getValue().equals("multiblock") && it.next().getValue().equals(":")) {
            Token locToken = it.next();
            if (locToken.getType() == 2) {
                int metaId = Integer.parseInt(locToken.getValue());
                return position -> new ExpressionCallStatic(position, environment, this.intGet, new Expression[]{new ExpressionInt(position, (long)metaId, (ZenType)ZenType.INT)});
            }
            StringBuilder sb = new StringBuilder(locToken.getValue());
            while (it.hasNext()) {
                sb.append(it.next().getValue());
            }
            return position -> new ExpressionCallStatic(position, environment, this.stringGet, new Expression[]{new ExpressionString(position, sb.toString())});
        }
        return null;
    }

    public static CustomMultiblock get(String loc) {
        return MultiblockRegistry.get(loc);
    }

    public static CustomMultiblock get(int metaId) {
        return MultiblockRegistry.get(metaId);
    }

    public Class<CustomMultiblock> getReturnedClass() {
        return CustomMultiblock.class;
    }

    public String getRegexMatchingString() {
        return "multiblock:.+";
    }
}

