/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.moreplates.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import panszelescik.morelibs.api.Helper;
import panszelescik.morelibs.api.IItemDamageble;
import panszelescik.morelibs.api.NBTHelper;
import panszelescik.moreplates.config.Config;

public class ItemHammer
extends Item
implements IItemDamageble {
    private static final Random RAND = new Random();

    public ItemHammer() {
        this.func_77642_a(this);
        this.func_77656_e(this.getDurability());
        this.field_77777_bU = 1;
        this.canRepair = false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getItemMaxDamage(ItemStack stack) {
        return this.getDurability();
    }

    public int getItemDamage(ItemStack stack) {
        return NBTHelper.getInt((ItemStack)stack, (String)"Damage", (int)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Helper.translate((String)(this.func_77658_a() + ".uses_left")) + (this.getItemMaxDamage(stack) - this.getItemDamage(stack)));
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        this.damageTool(container, 1, RAND, null);
        return container;
    }

    private void damageTool(ItemStack stack, int amount, Random rand, @Nullable EntityPlayer player) {
        if (amount <= 0) {
            return;
        }
        int unbreakLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        for (int i = 0; unbreakLevel > 0 && i < amount; ++i) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)unbreakLevel, (Random)rand)) continue;
            --amount;
        }
        if (amount <= 0) {
            return;
        }
        int curDamage = NBTHelper.getInt((ItemStack)stack, (String)"Damage", (int)0);
        curDamage += amount;
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)player, stack, curDamage);
        }
        if (curDamage >= this.getDurability()) {
            if (player != null) {
                player.func_70669_a(stack);
                player.func_71029_a(StatList.func_188059_c((Item)this));
            }
            stack.func_190918_g(1);
            return;
        }
        NBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)curDamage);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return NBTHelper.getInt((ItemStack)stack, (String)"Damage", (int)0) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getItemMaxDamage(stack);
        return (double)NBTHelper.getInt((ItemStack)stack, (String)"Damage", (int)0) / max;
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A;
    }

    private int getDurability() {
        return Config.getInt((String)"Hammer's durability", (String)"general", (int)150, (String)"Durability of Hammer");
    }
}

