/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.morelibs.config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigBase {
    private static Configuration cfg;
    private static String modid;

    public ConfigBase(String dir, String modid) {
        cfg = new Configuration(new File(Loader.instance().getConfigDir(), "/" + dir + ".cfg"));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
        ConfigBase.modid = modid;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(modid)) {
            this.loadConfig();
        }
    }

    public void loadConfig() {
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    public static Configuration getCfg() {
        return cfg;
    }

    public static String getModId() {
        return modid;
    }

    public static boolean getBoolean(String name, String category, boolean defaultValue, String comment) {
        return ConfigBase.getCfg().getBoolean(name, category, defaultValue, comment);
    }

    public static boolean getBoolean(String name, String category, String comment) {
        return ConfigBase.getCfg().getBoolean(name, category, true, comment);
    }

    public static float getFloat(String name, String category, float defaultValue, String comment) {
        return ConfigBase.getCfg().getFloat(name, category, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, comment);
    }

    public static int getInt(String name, String category, int intName, String comment) {
        return ConfigBase.getCfg().getInt(name, category, intName, 1, Integer.MAX_VALUE, comment);
    }

    public static String getString(String name, String category, String defaultValue, String comment) {
        return ConfigBase.getCfg().getString(name, category, defaultValue, comment);
    }

    public static String[] getStrings(String name, String category, String[] defaultValues, String comment) {
        return ConfigBase.getCfg().getStringList(name, category, defaultValues, comment);
    }
}

