/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IItemStack;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.TreeManager;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.CharcoalWall")
@ModOnly(value="forestry")
@ZenRegister
public class CharcoalPile {
    public static final String NAME = "Forestry Charcoal Wall";

    @ZenMethod
    public static void addWall(IBlock block, int amount) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(CharcoalPile.asBlock(block), amount));
    }

    @ZenMethod
    public static void addWallState(crafttweaker.api.block.IBlockState state, int amount) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(CharcoalPile.asBlockState(state), amount));
    }

    @ZenMethod
    public static void addWallStack(IItemStack stack, int amount) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(CharcoalPile.asBlock(stack), amount));
    }

    @ZenMethod
    public static void removeWall(IBlock block) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(CharcoalPile.asBlock(block)));
    }

    @ZenMethod
    public static void removeWallState(crafttweaker.api.block.IBlockState state) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(CharcoalPile.asBlockState(state)));
    }

    @ZenMethod
    public static void removeWallStack(IItemStack stack) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(CharcoalPile.asBlock(stack)));
    }

    @Nullable
    private static Block asBlock(IBlock block) {
        Object internal = block.getDefinition().getInternal();
        if (!(internal instanceof Block)) {
            CraftTweakerAPI.logError((String)("Not a valid block: " + block));
            return null;
        }
        return (Block)internal;
    }

    @Nullable
    private static IBlockState asBlockState(crafttweaker.api.block.IBlockState blockstate) {
        Object internal = blockstate.getInternal();
        if (!(internal instanceof IBlockState)) {
            CraftTweakerAPI.logError((String)("Not a valid blockstate: " + blockstate));
            return null;
        }
        return (IBlockState)internal;
    }

    @Nullable
    private static Block asBlock(IItemStack stack) {
        if (!InputHelper.isABlock((IItemStack)stack)) {
            CraftTweakerAPI.logError((String)("Not a valid block: " + stack.getDisplayName()));
            return null;
        }
        return CharcoalPile.asBlock(stack.asBlock());
    }

    private static class BaseCharcoal
    extends BaseAction {
        protected static final ICharcoalManager manager = TreeManager.charcoalManager;
        protected final Block block;
        protected final IBlockState state;

        protected BaseCharcoal(Block block) {
            super(CharcoalPile.NAME);
            this.block = block;
            this.state = null;
        }

        protected BaseCharcoal(IBlockState state) {
            super(CharcoalPile.NAME);
            this.state = state;
            this.block = null;
        }

        public void apply() {
            CraftTweakerAPI.logError((String)"BaseCharcoal.apply() is not implemented");
        }
    }

    private static class Remove
    extends BaseCharcoal {
        protected Remove(Block block) {
            super(block);
        }

        protected Remove(IBlockState state) {
            super(state);
        }

        @Override
        public void apply() {
            if (manager == null) {
                CraftTweakerAPI.logError((String)"Charcoal manager is null, probably the charcoal module is not enabled");
                return;
            }
            boolean success = false;
            if (this.block != null) {
                success = manager.removeWall(this.block);
            } else if (this.state != null) {
                success = manager.removeWall(this.state);
            } else {
                CraftTweakerAPI.logError((String)"Both block and blockstate were null, no wall removed");
            }
            if (!success) {
                CraftTweakerAPI.logError((String)"Removing wall was not successful");
            }
        }
    }

    private static class Add
    extends BaseCharcoal {
        private final int amount;

        protected Add(Block block, int amount) {
            super(block);
            this.amount = amount;
        }

        protected Add(IBlockState state, int amount) {
            super(state);
            this.amount = amount;
        }

        @Override
        public void apply() {
            if (manager == null) {
                CraftTweakerAPI.logError((String)"Charcoal manager is null, probably the charcoal module is not enabled");
                return;
            }
            if (this.block != null) {
                manager.registerWall(this.block, this.amount);
            } else if (this.state != null) {
                manager.registerWall(this.state, this.amount);
            } else {
                CraftTweakerAPI.logError((String)"Both block and blockstate were null, no wall registered");
            }
        }
    }
}

