/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.item.types.ComponentTypes;
import WayofTime.bloodmagic.potion.BMPotionUtils;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTablePotionRecipe;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTableRecipe;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotionEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.AlchemyTable")
@ZenRegister
@ModOnly(value="bloodmagic")
public class AlchemyTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, int syphon, int ticks, int minTier) {
        if (inputs.length == 0 || inputs.length > 6) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 6!");
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), syphon, ticks, minTier, InputHelper.toObjects((IIngredient[])inputs)));
    }

    @ZenMethod
    public static void addPotionRecipe(IItemStack[] inputs, IPotionEffect effects, int syphon, int ticks, int minTier) {
        if (inputs.length == 0 || inputs.length > 5) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 5 (to account for catalysts)!");
            return;
        }
        List<ItemStack> inputsNew = AlchemyTable.withoutFlask(Arrays.asList(InputHelper.toStacks((IItemStack[])inputs)));
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddPotion(inputsNew, CraftTweakerMC.getPotionEffect((IPotionEffect)effects), syphon, ticks, minTier));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack[] inputs) {
        if (inputs.length == 0 || inputs.length > 6) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 6!");
            return;
        }
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStacks((IItemStack[])inputs)));
    }

    public static List<ItemStack> withoutFlask(List<ItemStack> inputs) {
        ArrayList<ItemStack> inputsNew = new ArrayList<ItemStack>();
        for (ItemStack item : inputs) {
            if (item.func_77973_b() == RegistrarBloodMagicItems.POTION_FLASK) continue;
            inputsNew.add(item);
        }
        return inputsNew;
    }

    public static String[] getStringFromStacks(Object[] arr) {
        String[] retArr = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            retArr[i] = arr[i].toString();
        }
        return retArr;
    }

    private static class Remove
    extends BaseAction {
        private ItemStack[] inputs;

        public Remove(ItemStack[] inputs) {
            super("AlchemyTable");
            this.inputs = inputs;
        }

        public void apply() {
            if (!BloodMagicAPI.INSTANCE.getRecipeRegistrar().removeAlchemyTable(this.inputs)) {
                ArrayList<ItemStack> inputsList = new ArrayList<ItemStack>(Arrays.asList(this.inputs));
                AlchemyTableRecipe recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(inputsList, null, null);
                if (recipe == null) {
                    return;
                }
                AlchemyTableRecipeRegistry.removeRecipe((AlchemyTableRecipe)recipe);
                List<ItemStack> newInputsList = AlchemyTable.withoutFlask(inputsList);
                newInputsList.add(recipe.getRecipeOutput(inputsList));
                newInputsList.add(ComponentTypes.CATALYST_POWER_1.getStack());
                recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(newInputsList, null, null);
                if (recipe != null) {
                    AlchemyTableRecipeRegistry.removeRecipe((AlchemyTableRecipe)recipe);
                }
                newInputsList.remove(ComponentTypes.CATALYST_POWER_1.getStack());
                newInputsList.add(ComponentTypes.CATALYST_LENGTH_1.getStack());
                recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(newInputsList, null, null);
                if (recipe != null) {
                    AlchemyTableRecipeRegistry.removeRecipe((AlchemyTableRecipe)recipe);
                }
            }
        }

        public String describe() {
            return "Removing AlchemyTable recipe for: [" + String.join((CharSequence)",", AlchemyTable.getStringFromStacks(this.inputs)) + "]";
        }
    }

    private static class AddPotion
    extends BaseAction {
        private int syphon;
        private int ticks;
        private int minTier;
        private List<ItemStack> inputs;
        private PotionEffect effect;

        public AddPotion(List<ItemStack> inputs, PotionEffect effect, int syphon, int ticks, int minTier) {
            super("AlchemyTable");
            this.inputs = inputs;
            this.effect = effect;
            this.syphon = syphon;
            this.ticks = ticks;
            this.minTier = minTier;
        }

        public void apply() {
            AlchemyTableRecipeRegistry.registerRecipe((AlchemyTableRecipe)new AlchemyTablePotionRecipe(this.syphon, this.ticks, this.minTier, this.inputs, this.effect));
            ArrayList<ItemStack> lengtheningList = new ArrayList<ItemStack>();
            lengtheningList.addAll(this.inputs);
            lengtheningList.add(ComponentTypes.CATALYST_LENGTH_1.getStack());
            AlchemyTableRecipeRegistry.registerRecipe((AlchemyTableRecipe)BMPotionUtils.getLengthAugmentRecipe((int)this.syphon, (int)this.ticks, (int)this.minTier, lengtheningList, (PotionEffect)this.effect, (double)1.0));
            ArrayList<ItemStack> powerList = new ArrayList<ItemStack>();
            powerList.addAll(this.inputs);
            powerList.add(ComponentTypes.CATALYST_POWER_1.getStack());
            AlchemyTableRecipeRegistry.registerRecipe((AlchemyTableRecipe)BMPotionUtils.getPowerAugmentRecipe((int)this.syphon, (int)this.ticks, (int)this.minTier, powerList, (PotionEffect)this.effect, (int)1));
        }

        public String describe() {
            return "Adding AlchemyTable potion recipe for: [" + this.effect.func_76453_d() + "] with input: [" + String.join((CharSequence)",", AlchemyTable.getStringFromStacks(this.inputs.toArray())) + "] syphon: " + this.syphon + ", ticks: " + this.ticks + ", minTier: " + this.minTier;
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack output;
        private int syphon;
        private int ticks;
        private int minTier;
        private Object[] inputs;

        public Add(ItemStack output, int syphon, int ticks, int minTier, Object[] inputs) {
            super("AlchemyTable");
            this.output = output;
            this.syphon = syphon;
            this.ticks = ticks;
            this.minTier = minTier;
            this.inputs = inputs;
        }

        public void apply() {
            BloodMagicAPI.INSTANCE.getRecipeRegistrar().addAlchemyTable(this.output, this.syphon, this.ticks, this.minTier, this.inputs);
        }

        public String describe() {
            return "Adding AlchemyTable recipe for: " + this.output + " from: [" + String.join((CharSequence)",", AlchemyTable.getStringFromStacks(this.inputs)) + "] syphon: " + this.syphon + ", ticks: " + this.ticks + ", minTier: " + this.minTier;
        }
    }
}

