/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2FloatMap;
import it.unimi.dsi.fastutil.objects.AbstractReference2FloatSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatSortedMap;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.ToDoubleFunction;

public class Reference2FloatLinkedOpenHashMap<K>
extends AbstractReference2FloatSortedMap<K>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient float[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Reference2FloatSortedMap.FastSortedEntrySet<K> entries;
    protected transient ReferenceSortedSet<K> keys;
    protected transient FloatCollection values;

    public Reference2FloatLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n + 1];
        this.value = new float[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public Reference2FloatLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Reference2FloatLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2FloatLinkedOpenHashMap(Map<? extends K, ? extends Float> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2FloatLinkedOpenHashMap(Map<? extends K, ? extends Float> m) {
        this(m, 0.75f);
    }

    public Reference2FloatLinkedOpenHashMap(Reference2FloatMap<K> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2FloatLinkedOpenHashMap(Reference2FloatMap<K> m) {
        this(m, 0.75f);
    }

    public Reference2FloatLinkedOpenHashMap(K[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2FloatLinkedOpenHashMap(K[] k, float[] v) {
        this(k, v, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private float removeEntry(int pos2) {
        float oldValue = this.value[pos2];
        --this.size;
        this.fixPointers(pos2);
        this.shiftKeys(pos2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private float removeNullEntry() {
        this.containsNullKey = false;
        this.key[this.n] = null;
        float oldValue = this.value[this.n];
        --this.size;
        this.fixPointers(this.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Float> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int find(K k) {
        if (k == null) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return -(pos2 + 1);
        }
        if (k == curr) {
            return pos2;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return -(pos2 + 1);
        } while (k != curr);
        return pos2;
    }

    private void insert(int pos2, K k, float v) {
        if (pos2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public float put(K k, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return this.defRetValue;
        }
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    private float addToValue(int pos2, float incr) {
        float oldValue = this.value[pos2];
        this.value[pos2] = oldValue + incr;
        return oldValue;
    }

    public float addTo(K k, float incr) {
        int pos2;
        if (k == null) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos2 = this.n;
            this.containsNullKey = true;
        } else {
            K[] key = this.key;
            pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
            K curr = key[pos2];
            if (curr != null) {
                if (curr == k) {
                    return this.addToValue(pos2, incr);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) {
                    if (curr != k) continue;
                    return this.addToValue(pos2, incr);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos2) {
        K[] key = this.key;
        while (true) {
            K curr;
            int last = pos2;
            pos2 = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos2]) == null) {
                    key[last] = null;
                    return;
                }
                int slot = HashCommon.mix(System.identityHashCode(curr)) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos2];
            this.fixPointers(pos2, last);
        }
    }

    @Override
    public float removeFloat(Object k) {
        if (k == null) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.removeEntry(pos2);
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.removeEntry(pos2);
    }

    private float setValue(int pos2, float v) {
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    public float removeFirstFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos2 = this.first;
        this.first = (int)this.link[pos2];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        --this.size;
        float v = this.value[pos2];
        if (pos2 == this.n) {
            this.containsNullKey = false;
            this.key[this.n] = null;
        } else {
            this.shiftKeys(pos2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v;
    }

    public float removeLastFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos2 = this.last;
        this.last = (int)(this.link[pos2] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        --this.size;
        float v = this.value[pos2];
        if (pos2 == this.n) {
            this.containsNullKey = false;
            this.key[this.n] = null;
        } else {
            this.shiftKeys(pos2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public float getAndMoveToFirst(K k) {
        if (k == null) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return this.defRetValue;
        }
        if (k == curr) {
            this.moveIndexToFirst(pos2);
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (k != curr);
        this.moveIndexToFirst(pos2);
        return this.value[pos2];
    }

    public float getAndMoveToLast(K k) {
        if (k == null) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return this.defRetValue;
        }
        if (k == curr) {
            this.moveIndexToLast(pos2);
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (k != curr);
        this.moveIndexToLast(pos2);
        return this.value[pos2];
    }

    public float putAndMoveToFirst(K k, float v) {
        int pos2;
        if (k == null) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos2 = this.n;
        } else {
            K[] key = this.key;
            pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
            K curr = key[pos2];
            if (curr != null) {
                if (curr == k) {
                    this.moveIndexToFirst(pos2);
                    return this.setValue(pos2, v);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) {
                    if (curr != k) continue;
                    this.moveIndexToFirst(pos2);
                    return this.setValue(pos2, v);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public float putAndMoveToLast(K k, float v) {
        int pos2;
        if (k == null) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos2 = this.n;
        } else {
            K[] key = this.key;
            pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
            K curr = key[pos2];
            if (curr != null) {
                if (curr == k) {
                    this.moveIndexToLast(pos2);
                    return this.setValue(pos2, v);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) {
                    if (curr != k) continue;
                    this.moveIndexToLast(pos2);
                    return this.setValue(pos2, v);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public float getFloat(Object k) {
        if (k == null) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.value[pos2];
    }

    @Override
    public boolean containsKey(Object k) {
        if (k == null) {
            return this.containsNullKey;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return false;
        } while (k != curr);
        return true;
    }

    @Override
    public boolean containsValue(float v) {
        float[] value = this.value;
        K[] key = this.key;
        if (this.containsNullKey && Float.floatToIntBits(value[this.n]) == Float.floatToIntBits(v)) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == null || Float.floatToIntBits(value[i]) != Float.floatToIntBits(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getOrDefault(Object k, float defaultValue) {
        if (k == null) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return defaultValue;
        }
        if (k == curr) {
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return defaultValue;
        } while (k != curr);
        return this.value[pos2];
    }

    @Override
    public float putIfAbsent(K k, float v) {
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        this.insert(-pos2 - 1, k, v);
        return this.defRetValue;
    }

    @Override
    public boolean remove(Object k, float v) {
        if (k == null) {
            if (this.containsNullKey && Float.floatToIntBits(v) == Float.floatToIntBits(this.value[this.n])) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return false;
        }
        if (k == curr && Float.floatToIntBits(v) == Float.floatToIntBits(this.value[pos2])) {
            this.removeEntry(pos2);
            return true;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return false;
        } while (k != curr || Float.floatToIntBits(v) != Float.floatToIntBits(this.value[pos2]));
        this.removeEntry(pos2);
        return true;
    }

    @Override
    public boolean replace(K k, float oldValue, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0 || Float.floatToIntBits(oldValue) != Float.floatToIntBits(this.value[pos2])) {
            return false;
        }
        this.value[pos2] = v;
        return true;
    }

    @Override
    public float replace(K k, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    @Override
    public float computeFloatIfAbsent(K k, ToDoubleFunction<? super K> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        float newValue = SafeMath.safeDoubleToFloat(mappingFunction.applyAsDouble(k));
        this.insert(-pos2 - 1, k, newValue);
        return newValue;
    }

    @Override
    public float computeFloatIfPresent(K k, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        Float newValue = remappingFunction.apply(k, Float.valueOf(this.value[pos2]));
        if (newValue == null) {
            if (k == null) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue.floatValue();
        return this.value[pos2];
    }

    @Override
    public float computeFloat(K k, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        Float newValue = remappingFunction.apply(k, pos2 >= 0 ? Float.valueOf(this.value[pos2]) : null);
        if (newValue == null) {
            if (pos2 >= 0) {
                if (k == null) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos2);
                }
            }
            return this.defRetValue;
        }
        float newVal = newValue.floatValue();
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, newVal);
            return newVal;
        }
        this.value[pos2] = newVal;
        return this.value[pos2];
    }

    @Override
    public float mergeFloat(K k, float v, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return v;
        }
        Float newValue = remappingFunction.apply(Float.valueOf(this.value[pos2]), Float.valueOf(v));
        if (newValue == null) {
            if (k == null) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue.floatValue();
        return this.value[pos2];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Reference2FloatSortedMap<K> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference2FloatSortedMap<K> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference2FloatSortedMap<K> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Reference2FloatSortedMap.FastSortedEntrySet<K> reference2FloatEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ReferenceSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public FloatCollection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                @Override
                public FloatIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Reference2FloatLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(float v) {
                    return Reference2FloatLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Reference2FloatLinkedOpenHashMap.this.clear();
                }

                @Override
                public void forEach(DoubleConsumer consumer) {
                    if (Reference2FloatLinkedOpenHashMap.this.containsNullKey) {
                        consumer.accept(Reference2FloatLinkedOpenHashMap.this.value[Reference2FloatLinkedOpenHashMap.this.n]);
                    }
                    int pos2 = Reference2FloatLinkedOpenHashMap.this.n;
                    while (pos2-- != 0) {
                        if (Reference2FloatLinkedOpenHashMap.this.key[pos2] == null) continue;
                        consumer.accept(Reference2FloatLinkedOpenHashMap.this.value[pos2]);
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        K[] key = this.key;
        float[] value = this.value;
        int mask = newN - 1;
        Object[] newKey = new Object[newN + 1];
        float[] newValue = new float[newN + 1];
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] link = this.link;
        long[] newLink = new long[newN + 1];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos2;
            if (key[i] == null) {
                pos2 = newN;
            } else {
                pos2 = HashCommon.mix(System.identityHashCode(key[i])) & mask;
                while (newKey[pos2] != null) {
                    pos2 = pos2 + 1 & mask;
                }
            }
            newKey[pos2] = key[i];
            newValue[pos2] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos2;
                newLink[n2] = newLink[n2] ^ (newLink[pos2] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos2;
            } else {
                newPrev = this.first = pos2;
                newLink[pos2] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Reference2FloatLinkedOpenHashMap<K> clone() {
        Reference2FloatLinkedOpenHashMap c;
        try {
            c = (Reference2FloatLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (Object[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == null) {
                ++i;
            }
            if (this != this.key[i]) {
                t = System.identityHashCode(this.key[i]);
            }
            h += (t ^= HashCommon.float2int(this.value[i]));
            ++i;
        }
        if (this.containsNullKey) {
            h += HashCommon.float2int(this.value[this.n]);
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        float[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeFloat(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] key = this.key;
        this.value = new float[this.n + 1];
        float[] value = this.value;
        this.link = new long[this.n + 1];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        while (i-- != 0) {
            int pos2;
            Object k = s.readObject();
            float v = s.readFloat();
            if (k == null) {
                pos2 = this.n;
                this.containsNullKey = true;
            } else {
                pos2 = HashCommon.mix(System.identityHashCode(k)) & this.mask;
                while (key[pos2] != null) {
                    pos2 = pos2 + 1 & this.mask;
                }
            }
            key[pos2] = k;
            value[pos2] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos2;
                link[n2] = link[n2] ^ (link[pos2] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos2;
                continue;
            }
            prev = this.first = pos2;
            int n = pos2;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatListIterator {
        @Override
        public float previousFloat() {
            return Reference2FloatLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public float nextFloat() {
            return Reference2FloatLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractReferenceSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectListIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            if (Reference2FloatLinkedOpenHashMap.this.containsNullKey) {
                consumer.accept(Reference2FloatLinkedOpenHashMap.this.key[Reference2FloatLinkedOpenHashMap.this.n]);
            }
            int pos2 = Reference2FloatLinkedOpenHashMap.this.n;
            while (pos2-- != 0) {
                Object k = Reference2FloatLinkedOpenHashMap.this.key[pos2];
                if (k == null) continue;
                consumer.accept(k);
            }
        }

        @Override
        public int size() {
            return Reference2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Reference2FloatLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Reference2FloatLinkedOpenHashMap.this.size;
            Reference2FloatLinkedOpenHashMap.this.removeFloat(k);
            return Reference2FloatLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Reference2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Reference2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Reference2FloatLinkedOpenHashMap.this.key[Reference2FloatLinkedOpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (Reference2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Reference2FloatLinkedOpenHashMap.this.key[Reference2FloatLinkedOpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public ReferenceSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k) {
            super(k);
        }

        @Override
        public K previous() {
            return Reference2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Reference2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Reference2FloatMap.Entry<K>>
    implements Reference2FloatSortedMap.FastSortedEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Reference2FloatMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Reference2FloatMap.Entry<K>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Reference2FloatMap.Entry<K>> subSet(Reference2FloatMap.Entry<K> fromElement, Reference2FloatMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Reference2FloatMap.Entry<K>> headSet(Reference2FloatMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Reference2FloatMap.Entry<K>> tailSet(Reference2FloatMap.Entry<K> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference2FloatMap.Entry<K> first() {
            if (Reference2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Reference2FloatLinkedOpenHashMap.this.first);
        }

        @Override
        public Reference2FloatMap.Entry<K> last() {
            if (Reference2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Reference2FloatLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null || !(e.getValue() instanceof Float)) {
                return false;
            }
            Object k = e.getKey();
            float v = ((Float)e.getValue()).floatValue();
            if (k == null) {
                return Reference2FloatLinkedOpenHashMap.this.containsNullKey && Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[Reference2FloatLinkedOpenHashMap.this.n]) == Float.floatToIntBits(v);
            }
            K[] key = Reference2FloatLinkedOpenHashMap.this.key;
            int pos2 = HashCommon.mix(System.identityHashCode(k)) & Reference2FloatLinkedOpenHashMap.this.mask;
            Object curr = key[pos2];
            if (curr == null) {
                return false;
            }
            if (k == curr) {
                return Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v);
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Reference2FloatLinkedOpenHashMap.this.mask]) != null) continue;
                return false;
            } while (k != curr);
            return Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null || !(e.getValue() instanceof Float)) {
                return false;
            }
            Object k = e.getKey();
            float v = ((Float)e.getValue()).floatValue();
            if (k == null) {
                if (Reference2FloatLinkedOpenHashMap.this.containsNullKey && Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[Reference2FloatLinkedOpenHashMap.this.n]) == Float.floatToIntBits(v)) {
                    Reference2FloatLinkedOpenHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            K[] key = Reference2FloatLinkedOpenHashMap.this.key;
            int pos2 = HashCommon.mix(System.identityHashCode(k)) & Reference2FloatLinkedOpenHashMap.this.mask;
            Object curr = key[pos2];
            if (curr == null) {
                return false;
            }
            if (curr == k) {
                if (Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v)) {
                    Reference2FloatLinkedOpenHashMap.this.removeEntry(pos2);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Reference2FloatLinkedOpenHashMap.this.mask]) != null) continue;
                return false;
            } while (curr != k || Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[pos2]) != Float.floatToIntBits(v));
            Reference2FloatLinkedOpenHashMap.this.removeEntry(pos2);
            return true;
        }

        @Override
        public int size() {
            return Reference2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Reference2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectListIterator<Reference2FloatMap.Entry<K>> iterator(Reference2FloatMap.Entry<K> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectListIterator<Reference2FloatMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectListIterator<Reference2FloatMap.Entry<K>> fastIterator(Reference2FloatMap.Entry<K> from) {
            return new FastEntryIterator(from.getKey());
        }

        @Override
        public void forEach(Consumer<? super Reference2FloatMap.Entry<K>> consumer) {
            int i = Reference2FloatLinkedOpenHashMap.this.size;
            int next = Reference2FloatLinkedOpenHashMap.this.first;
            while (i-- != 0) {
                int curr = next;
                next = (int)Reference2FloatLinkedOpenHashMap.this.link[curr];
                consumer.accept(new AbstractReference2FloatMap.BasicEntry(Reference2FloatLinkedOpenHashMap.this.key[curr], Reference2FloatLinkedOpenHashMap.this.value[curr]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Reference2FloatMap.Entry<K>> consumer) {
            AbstractReference2FloatMap.BasicEntry entry = new AbstractReference2FloatMap.BasicEntry();
            int i = Reference2FloatLinkedOpenHashMap.this.size;
            int next = Reference2FloatLinkedOpenHashMap.this.first;
            while (i-- != 0) {
                int curr = next;
                next = (int)Reference2FloatLinkedOpenHashMap.this.link[curr];
                entry.key = Reference2FloatLinkedOpenHashMap.this.key[curr];
                entry.value = Reference2FloatLinkedOpenHashMap.this.value[curr];
                consumer.accept(entry);
            }
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Reference2FloatMap.Entry<K>> {
        final MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Reference2FloatMap.Entry<K>> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        protected MapIterator() {
            this.next = Reference2FloatLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(K from) {
            if (from == null) {
                if (Reference2FloatLinkedOpenHashMap.this.containsNullKey) {
                    this.next = (int)Reference2FloatLinkedOpenHashMap.this.link[Reference2FloatLinkedOpenHashMap.this.n];
                    this.prev = Reference2FloatLinkedOpenHashMap.this.n;
                    return;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            if (Reference2FloatLinkedOpenHashMap.this.key[Reference2FloatLinkedOpenHashMap.this.last] == from) {
                this.prev = Reference2FloatLinkedOpenHashMap.this.last;
                this.index = Reference2FloatLinkedOpenHashMap.this.size;
                return;
            }
            int pos2 = HashCommon.mix(System.identityHashCode(from)) & Reference2FloatLinkedOpenHashMap.this.mask;
            while (Reference2FloatLinkedOpenHashMap.this.key[pos2] != null) {
                if (Reference2FloatLinkedOpenHashMap.this.key[pos2] == from) {
                    this.next = (int)Reference2FloatLinkedOpenHashMap.this.link[pos2];
                    this.prev = pos2;
                    return;
                }
                pos2 = pos2 + 1 & Reference2FloatLinkedOpenHashMap.this.mask;
            }
            throw new NoSuchElementException("The key " + from + " does not belong to this map.");
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Reference2FloatLinkedOpenHashMap.this.size;
                return;
            }
            int pos2 = Reference2FloatLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos2 != this.prev) {
                pos2 = (int)Reference2FloatLinkedOpenHashMap.this.link[pos2];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = (int)Reference2FloatLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = (int)(Reference2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Reference2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Reference2FloatLinkedOpenHashMap.this.link[this.curr];
            }
            --Reference2FloatLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Reference2FloatLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Reference2FloatLinkedOpenHashMap.this.link[n] = Reference2FloatLinkedOpenHashMap.this.link[n] ^ (Reference2FloatLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Reference2FloatLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Reference2FloatLinkedOpenHashMap.this.link[n] = Reference2FloatLinkedOpenHashMap.this.link[n] ^ (Reference2FloatLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos2 = this.curr;
            this.curr = -1;
            if (pos2 != Reference2FloatLinkedOpenHashMap.this.n) {
                K[] key = Reference2FloatLinkedOpenHashMap.this.key;
                while (true) {
                    Object curr;
                    int last = pos2;
                    pos2 = last + 1 & Reference2FloatLinkedOpenHashMap.this.mask;
                    while (true) {
                        if ((curr = key[pos2]) == null) {
                            key[last] = null;
                            return;
                        }
                        int slot = HashCommon.mix(System.identityHashCode(curr)) & Reference2FloatLinkedOpenHashMap.this.mask;
                        if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                        pos2 = pos2 + 1 & Reference2FloatLinkedOpenHashMap.this.mask;
                    }
                    key[last] = curr;
                    Reference2FloatLinkedOpenHashMap.this.value[last] = Reference2FloatLinkedOpenHashMap.this.value[pos2];
                    if (this.next == pos2) {
                        this.next = last;
                    }
                    if (this.prev == pos2) {
                        this.prev = last;
                    }
                    Reference2FloatLinkedOpenHashMap.this.fixPointers(pos2, last);
                }
            }
            Reference2FloatLinkedOpenHashMap.this.containsNullKey = false;
            Reference2FloatLinkedOpenHashMap.this.key[Reference2FloatLinkedOpenHashMap.this.n] = null;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }

        public void set(Reference2FloatMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Reference2FloatMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    final class MapEntry
    implements Reference2FloatMap.Entry<K>,
    Map.Entry<K, Float> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public K getKey() {
            return Reference2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public float getFloatValue() {
            return Reference2FloatLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public float setValue(float v) {
            float oldValue = Reference2FloatLinkedOpenHashMap.this.value[this.index];
            Reference2FloatLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        @Deprecated
        public Float getValue() {
            return Float.valueOf(Reference2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        @Deprecated
        public Float setValue(Float v) {
            return Float.valueOf(this.setValue(v.floatValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2FloatLinkedOpenHashMap.this.key[this.index] == e.getKey() && Float.floatToIntBits(Reference2FloatLinkedOpenHashMap.this.value[this.index]) == Float.floatToIntBits(((Float)e.getValue()).floatValue());
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(Reference2FloatLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.float2int(Reference2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Reference2FloatLinkedOpenHashMap.this.key[this.index] + "=>" + Reference2FloatLinkedOpenHashMap.this.value[this.index];
        }
    }
}

